/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media;

import android.util.Log;
import android.util.SparseArray;
import com.akamai.amp.media.IPlayerEventsListener;
import java.lang.reflect.Field;

public class PlayerEvents {
    private static final String TAG = PlayerEvents.class.getSimpleName();
    private static final String UNKNOWN_EVENT = "UNKNOWN_EVENT";
    private static final int INVALID_VALUE = -1;
    private static final SparseArray<String> EVENT_NAMES = PlayerEvents.createEventsArray();

    private PlayerEvents() {
    }

    private static SparseArray<String> createEventsArray() {
        Field[] declaredFields;
        SparseArray result = new SparseArray();
        for (Field field : declaredFields = IPlayerEventsListener.class.getDeclaredFields()) {
            String name = field.getName();
            int value = PlayerEvents.getValue(field);
            if (value == -1) continue;
            result.put(value, (Object)name);
        }
        return result;
    }

    private static int getValue(Field field) {
        try {
            int value = (Integer)field.get(null);
            return value;
        }
        catch (ClassCastException | IllegalAccessException e) {
            Log.e((String)TAG, (String)"Initialization error", (Throwable)e);
            return -1;
        }
    }

    @Deprecated
    public static String getName(int eventID) {
        return PlayerEvents.toString(eventID);
    }

    public static String toString(int eventID) {
        String value = (String)EVENT_NAMES.get(eventID);
        if (value == null || value.isEmpty()) {
            return UNKNOWN_EVENT;
        }
        return value;
    }

    static int count() {
        int size = EVENT_NAMES.size();
        return size;
    }
}

