/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.smoothstreaming;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ExoPlayerLibraryInfo;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.offline.FilteringManifestParser;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.source.BaseMediaSource;
import com.akamai.amp.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceDrmHelper;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.SinglePeriodTimeline;
import com.akamai.amp.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.akamai.amp.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.akamai.amp.exoplayer2.source.smoothstreaming.SsMediaPeriod;
import com.akamai.amp.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.akamai.amp.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.Loader;
import com.akamai.amp.exoplayer2.upstream.LoaderErrorThrower;
import com.akamai.amp.exoplayer2.upstream.ParsingLoadable;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SsMediaSource
extends BaseMediaSource
implements Loader.Callback<ParsingLoadable<SsManifest>> {
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_MS = 30000L;
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private final boolean sideloadedManifest;
    private final Uri manifestUri;
    private final MediaItem.PlaybackProperties playbackProperties;
    private final MediaItem mediaItem;
    private final DataSource.Factory manifestDataSourceFactory;
    private final SsChunkSource.Factory chunkSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final long livePresentationDelayMs;
    private final MediaSourceEventListener.EventDispatcher manifestEventDispatcher;
    private final ParsingLoadable.Parser<? extends SsManifest> manifestParser;
    private final ArrayList<SsMediaPeriod> mediaPeriods;
    private DataSource manifestDataSource;
    private Loader manifestLoader;
    private LoaderErrorThrower manifestLoaderErrorThrower;
    @Nullable
    private TransferListener mediaTransferListener;
    private long manifestLoadStartTimestamp;
    private SsManifest manifest;
    private Handler manifestRefreshHandler;

    @Deprecated
    public SsMediaSource(SsManifest manifest, SsChunkSource.Factory chunkSourceFactory, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
        this(manifest, chunkSourceFactory, 3, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(SsManifest manifest, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
        this(new MediaItem.Builder().setUri(Uri.EMPTY).setMimeType("application/vnd.ms-sstr+xml").build(), manifest, null, null, chunkSourceFactory, new DefaultCompositeSequenceableLoaderFactory(), DrmSessionManager.getDummyDrmSessionManager(), new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount), 30000L);
        if (eventHandler != null && eventListener != null) {
            this.addEventListener(eventHandler, eventListener);
        }
    }

    @Deprecated
    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, SsChunkSource.Factory chunkSourceFactory, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, chunkSourceFactory, 3, 30000L, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, new SsManifestParser(), chunkSourceFactory, minLoadableRetryCount, livePresentationDelayMs, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, ParsingLoadable.Parser<? extends SsManifest> manifestParser, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
        this(new MediaItem.Builder().setUri(manifestUri).setMimeType("application/vnd.ms-sstr+xml").build(), null, manifestDataSourceFactory, manifestParser, chunkSourceFactory, new DefaultCompositeSequenceableLoaderFactory(), DrmSessionManager.getDummyDrmSessionManager(), new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount), livePresentationDelayMs);
        if (eventHandler != null && eventListener != null) {
            this.addEventListener(eventHandler, eventListener);
        }
    }

    private SsMediaSource(MediaItem mediaItem, @Nullable SsManifest manifest, @Nullable DataSource.Factory manifestDataSourceFactory, @Nullable ParsingLoadable.Parser<? extends SsManifest> manifestParser, SsChunkSource.Factory chunkSourceFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, long livePresentationDelayMs) {
        Assertions.checkState(manifest == null || !manifest.isLive);
        this.mediaItem = mediaItem;
        this.playbackProperties = Assertions.checkNotNull(mediaItem.playbackProperties);
        this.manifest = manifest;
        this.manifestUri = this.playbackProperties.uri.equals((Object)Uri.EMPTY) ? null : Util.fixSmoothStreamingIsmManifestUri(this.playbackProperties.uri);
        this.manifestDataSourceFactory = manifestDataSourceFactory;
        this.manifestParser = manifestParser;
        this.chunkSourceFactory = chunkSourceFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.livePresentationDelayMs = livePresentationDelayMs;
        this.manifestEventDispatcher = this.createEventDispatcher(null);
        this.sideloadedManifest = manifest != null;
        this.mediaPeriods = new ArrayList();
    }

    @Override
    public boolean isLive() {
        if (this.manifest == null) {
            return false;
        }
        return this.manifest.isLive;
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.playbackProperties.tag;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        if (this.sideloadedManifest) {
            this.manifestLoaderErrorThrower = new LoaderErrorThrower.Dummy();
            this.processManifest();
        } else {
            this.manifestDataSource = this.manifestDataSourceFactory.createDataSource();
            this.manifestLoader = new Loader("Loader:Manifest");
            this.manifestLoaderErrorThrower = this.manifestLoader;
            this.manifestRefreshHandler = Util.createHandlerForCurrentLooper();
            this.startLoadingManifest();
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher = this.createEventDispatcher(id);
        DrmSessionEventListener.EventDispatcher drmEventDispatcher = this.createDrmEventDispatcher(id);
        SsMediaPeriod period = new SsMediaPeriod(this.manifest, this.chunkSourceFactory, this.mediaTransferListener, this.compositeSequenceableLoaderFactory, this.drmSessionManager, drmEventDispatcher, this.loadErrorHandlingPolicy, mediaSourceEventDispatcher, this.manifestLoaderErrorThrower, allocator);
        this.mediaPeriods.add(period);
        return period;
    }

    @Override
    public void releasePeriod(MediaPeriod period) {
        ((SsMediaPeriod)period).release();
        this.mediaPeriods.remove(period);
    }

    @Override
    protected void releaseSourceInternal() {
        this.manifest = this.sideloadedManifest ? this.manifest : null;
        this.manifestDataSource = null;
        this.manifestLoadStartTimestamp = 0L;
        if (this.manifestLoader != null) {
            this.manifestLoader.release();
            this.manifestLoader = null;
        }
        if (this.manifestRefreshHandler != null) {
            this.manifestRefreshHandler.removeCallbacksAndMessages(null);
            this.manifestRefreshHandler = null;
        }
        this.drmSessionManager.release();
    }

    @Override
    public void onLoadCompleted(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCompleted(loadEventInfo, loadable.type);
        this.manifest = loadable.getResult();
        this.manifestLoadStartTimestamp = elapsedRealtimeMs - loadDurationMs;
        this.processManifest();
        this.scheduleManifestRefresh();
    }

    @Override
    public void onLoadCanceled(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCanceled(loadEventInfo, loadable.type);
    }

    @Override
    public Loader.LoadErrorAction onLoadError(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        MediaLoadData mediaLoadData;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount));
        Loader.LoadErrorAction loadErrorAction = retryDelayMs == -9223372036854775807L ? Loader.DONT_RETRY_FATAL : Loader.createRetryAction(false, retryDelayMs);
        boolean wasCanceled = !loadErrorAction.isRetry();
        this.manifestEventDispatcher.loadError(loadEventInfo, loadable.type, error, wasCanceled);
        if (wasCanceled) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return loadErrorAction;
    }

    private void processManifest() {
        SinglePeriodTimeline timeline;
        for (int i = 0; i < this.mediaPeriods.size(); ++i) {
            this.mediaPeriods.get(i).updateManifest(this.manifest);
        }
        long startTimeUs = Long.MAX_VALUE;
        long endTimeUs = Long.MIN_VALUE;
        for (SsManifest.StreamElement element : this.manifest.streamElements) {
            if (element.chunkCount <= 0) continue;
            startTimeUs = Math.min(startTimeUs, element.getStartTimeUs(0));
            endTimeUs = Math.max(endTimeUs, element.getStartTimeUs(element.chunkCount - 1) + element.getChunkDurationUs(element.chunkCount - 1));
        }
        if (startTimeUs == Long.MAX_VALUE) {
            long periodDurationUs = this.manifest.isLive ? -9223372036854775807L : 0L;
            timeline = new SinglePeriodTimeline(periodDurationUs, 0L, 0L, 0L, true, this.manifest.isLive, this.manifest.isLive, (Object)this.manifest, this.mediaItem);
        } else if (this.manifest.isLive) {
            long durationUs;
            long defaultStartPositionUs;
            if (this.manifest.dvrWindowLengthUs != -9223372036854775807L && this.manifest.dvrWindowLengthUs > 0L) {
                startTimeUs = Math.max(startTimeUs, endTimeUs - this.manifest.dvrWindowLengthUs);
            }
            if ((defaultStartPositionUs = (durationUs = endTimeUs - startTimeUs) - C.msToUs(this.livePresentationDelayMs)) < 5000000L) {
                defaultStartPositionUs = Math.min(5000000L, durationUs / 2L);
            }
            timeline = new SinglePeriodTimeline(-9223372036854775807L, durationUs, startTimeUs, defaultStartPositionUs, true, true, true, (Object)this.manifest, this.mediaItem);
        } else {
            long durationUs = this.manifest.durationUs != -9223372036854775807L ? this.manifest.durationUs : endTimeUs - startTimeUs;
            timeline = new SinglePeriodTimeline(startTimeUs + durationUs, durationUs, startTimeUs, 0L, true, false, false, (Object)this.manifest, this.mediaItem);
        }
        this.refreshSourceInfo(timeline);
    }

    private void scheduleManifestRefresh() {
        if (!this.manifest.isLive) {
            return;
        }
        long nextLoadTimestamp = this.manifestLoadStartTimestamp + 5000L;
        long delayUntilNextLoad = Math.max(0L, nextLoadTimestamp - SystemClock.elapsedRealtime());
        this.manifestRefreshHandler.postDelayed(this::startLoadingManifest, delayUntilNextLoad);
    }

    private void startLoadingManifest() {
        if (this.manifestLoader.hasFatalError()) {
            return;
        }
        ParsingLoadable<? extends SsManifest> loadable = new ParsingLoadable<SsManifest>(this.manifestDataSource, this.manifestUri, 4, this.manifestParser);
        long elapsedRealtimeMs = this.manifestLoader.startLoading(loadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type));
        this.manifestEventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, elapsedRealtimeMs), loadable.type);
    }

    static {
        ExoPlayerLibraryInfo.registerModule("goog.exo.smoothstreaming");
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final SsChunkSource.Factory chunkSourceFactory;
        private final MediaSourceDrmHelper mediaSourceDrmHelper;
        @Nullable
        private final DataSource.Factory manifestDataSourceFactory;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        @Nullable
        private DrmSessionManager drmSessionManager;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private long livePresentationDelayMs;
        @Nullable
        private ParsingLoadable.Parser<? extends SsManifest> manifestParser;
        private List<StreamKey> streamKeys;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultSsChunkSource.Factory(dataSourceFactory), dataSourceFactory);
        }

        public Factory(SsChunkSource.Factory chunkSourceFactory, @Nullable DataSource.Factory manifestDataSourceFactory) {
            this.chunkSourceFactory = Assertions.checkNotNull(chunkSourceFactory);
            this.manifestDataSourceFactory = manifestDataSourceFactory;
            this.mediaSourceDrmHelper = new MediaSourceDrmHelper();
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.livePresentationDelayMs = 30000L;
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.streamKeys = Collections.emptyList();
        }

        @Deprecated
        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        @Deprecated
        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            return this.setLoadErrorHandlingPolicy(new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount));
        }

        @Override
        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        public Factory setLivePresentationDelayMs(long livePresentationDelayMs) {
            this.livePresentationDelayMs = livePresentationDelayMs;
            return this;
        }

        public Factory setManifestParser(@Nullable ParsingLoadable.Parser<? extends SsManifest> manifestParser) {
            this.manifestParser = manifestParser;
            return this;
        }

        public Factory setCompositeSequenceableLoaderFactory(@Nullable CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory != null ? compositeSequenceableLoaderFactory : new DefaultCompositeSequenceableLoaderFactory();
            return this;
        }

        @Override
        public Factory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
            this.drmSessionManager = drmSessionManager;
            return this;
        }

        @Override
        public Factory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
            this.mediaSourceDrmHelper.setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
            return this;
        }

        @Override
        public Factory setDrmUserAgent(@Nullable String userAgent) {
            this.mediaSourceDrmHelper.setDrmUserAgent(userAgent);
            return this;
        }

        @Override
        @Deprecated
        public Factory setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null ? streamKeys : Collections.emptyList();
            return this;
        }

        @Override
        @Deprecated
        public SsMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).build());
        }

        public SsMediaSource createMediaSource(SsManifest manifest) {
            return this.createMediaSource(manifest, MediaItem.fromUri(Uri.EMPTY));
        }

        public SsMediaSource createMediaSource(SsManifest manifest, MediaItem mediaItem) {
            List<StreamKey> streamKeys;
            Assertions.checkArgument(!((SsManifest)manifest).isLive);
            List<StreamKey> list = streamKeys = mediaItem.playbackProperties != null && !mediaItem.playbackProperties.streamKeys.isEmpty() ? mediaItem.playbackProperties.streamKeys : this.streamKeys;
            if (!streamKeys.isEmpty()) {
                manifest = ((SsManifest)manifest).copy((List)streamKeys);
            }
            boolean hasUri = mediaItem.playbackProperties != null;
            boolean hasTag = hasUri && mediaItem.playbackProperties.tag != null;
            mediaItem = mediaItem.buildUpon().setMimeType("application/vnd.ms-sstr+xml").setUri(hasUri ? mediaItem.playbackProperties.uri : Uri.EMPTY).setTag(hasTag ? mediaItem.playbackProperties.tag : this.tag).setStreamKeys(streamKeys).build();
            return new SsMediaSource(mediaItem, (SsManifest)manifest, null, null, this.chunkSourceFactory, this.compositeSequenceableLoaderFactory, this.drmSessionManager != null ? this.drmSessionManager : this.mediaSourceDrmHelper.create(mediaItem), this.loadErrorHandlingPolicy, this.livePresentationDelayMs);
        }

        @Deprecated
        public SsMediaSource createMediaSource(SsManifest manifest, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            SsMediaSource mediaSource = this.createMediaSource(manifest);
            if (eventHandler != null && eventListener != null) {
                mediaSource.addEventListener(eventHandler, eventListener);
            }
            return mediaSource;
        }

        @Deprecated
        public SsMediaSource createMediaSource(Uri manifestUri, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            SsMediaSource mediaSource = this.createMediaSource(manifestUri);
            if (eventHandler != null && eventListener != null) {
                mediaSource.addEventListener(eventHandler, eventListener);
            }
            return mediaSource;
        }

        @Override
        public SsMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsStreamKeys;
            List<StreamKey> streamKeys;
            Assertions.checkNotNull(mediaItem.playbackProperties);
            ParsingLoadable.Parser<SsManifest> manifestParser = this.manifestParser;
            if (manifestParser == null) {
                manifestParser = new SsManifestParser();
            }
            List<StreamKey> list = streamKeys = !mediaItem.playbackProperties.streamKeys.isEmpty() ? mediaItem.playbackProperties.streamKeys : this.streamKeys;
            if (!streamKeys.isEmpty()) {
                manifestParser = new FilteringManifestParser<SsManifest>(manifestParser, streamKeys);
            }
            boolean needsTag = mediaItem.playbackProperties.tag == null && this.tag != null;
            boolean bl = needsStreamKeys = mediaItem.playbackProperties.streamKeys.isEmpty() && !streamKeys.isEmpty();
            if (needsTag && needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setStreamKeys(streamKeys).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setStreamKeys(streamKeys).build();
            }
            return new SsMediaSource(mediaItem, null, this.manifestDataSourceFactory, manifestParser, this.chunkSourceFactory, this.compositeSequenceableLoaderFactory, this.drmSessionManager != null ? this.drmSessionManager : this.mediaSourceDrmHelper.create(mediaItem), this.loadErrorHandlingPolicy, this.livePresentationDelayMs);
        }

        @Override
        public int[] getSupportedTypes() {
            return new int[]{1};
        }
    }
}

