/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.extractor.DefaultExtractorsFactory;
import com.akamai.amp.exoplayer2.extractor.ExtractorsFactory;
import com.akamai.amp.exoplayer2.source.BaseMediaSource;
import com.akamai.amp.exoplayer2.source.ForwardingTimeline;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceDrmHelper;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.ProgressiveMediaPeriod;
import com.akamai.amp.exoplayer2.source.SinglePeriodTimeline;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;

public final class ProgressiveMediaSource
extends BaseMediaSource
implements ProgressiveMediaPeriod.Listener {
    public static final int DEFAULT_LOADING_CHECK_INTERVAL_BYTES = 0x100000;
    private final MediaItem mediaItem;
    private final MediaItem.PlaybackProperties playbackProperties;
    private final DataSource.Factory dataSourceFactory;
    private final ExtractorsFactory extractorsFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadableLoadErrorHandlingPolicy;
    private final int continueLoadingCheckIntervalBytes;
    private boolean timelineIsPlaceholder;
    private long timelineDurationUs;
    private boolean timelineIsSeekable;
    private boolean timelineIsLive;
    @Nullable
    private TransferListener transferListener;

    @Override
    public boolean isLive() {
        return false;
    }

    ProgressiveMediaSource(MediaItem mediaItem, DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadableLoadErrorHandlingPolicy, int continueLoadingCheckIntervalBytes) {
        this.playbackProperties = Assertions.checkNotNull(mediaItem.playbackProperties);
        this.mediaItem = mediaItem;
        this.dataSourceFactory = dataSourceFactory;
        this.extractorsFactory = extractorsFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadableLoadErrorHandlingPolicy = loadableLoadErrorHandlingPolicy;
        this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
        this.timelineIsPlaceholder = true;
        this.timelineDurationUs = -9223372036854775807L;
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.playbackProperties.tag;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.transferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        this.notifySourceInfoRefreshed();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        DataSource dataSource = this.dataSourceFactory.createDataSource();
        if (this.transferListener != null) {
            dataSource.addTransferListener(this.transferListener);
        }
        return new ProgressiveMediaPeriod(this.playbackProperties.uri, dataSource, this.extractorsFactory, this.drmSessionManager, this.createDrmEventDispatcher(id), this.loadableLoadErrorHandlingPolicy, this.createEventDispatcher(id), this, allocator, this.playbackProperties.customCacheKey, this.continueLoadingCheckIntervalBytes);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((ProgressiveMediaPeriod)mediaPeriod).release();
    }

    @Override
    protected void releaseSourceInternal() {
        this.drmSessionManager.release();
    }

    @Override
    public void onSourceInfoRefreshed(long durationUs, boolean isSeekable, boolean isLive) {
        long l = durationUs = durationUs == -9223372036854775807L ? this.timelineDurationUs : durationUs;
        if (!this.timelineIsPlaceholder && this.timelineDurationUs == durationUs && this.timelineIsSeekable == isSeekable && this.timelineIsLive == isLive) {
            return;
        }
        this.timelineDurationUs = durationUs;
        this.timelineIsSeekable = isSeekable;
        this.timelineIsLive = isLive;
        this.timelineIsPlaceholder = false;
        this.notifySourceInfoRefreshed();
    }

    private void notifySourceInfoRefreshed() {
        Timeline timeline = new SinglePeriodTimeline(this.timelineDurationUs, this.timelineIsSeekable, false, this.timelineIsLive, null, this.mediaItem);
        if (this.timelineIsPlaceholder) {
            timeline = new ForwardingTimeline(timeline){

                @Override
                public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
                    super.getWindow(windowIndex, window, defaultPositionProjectionUs);
                    window.isPlaceholder = true;
                    return window;
                }
            };
        }
        this.refreshSourceInfo(timeline);
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final DataSource.Factory dataSourceFactory;
        private final MediaSourceDrmHelper mediaSourceDrmHelper;
        private ExtractorsFactory extractorsFactory;
        @Nullable
        private DrmSessionManager drmSessionManager;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private int continueLoadingCheckIntervalBytes;
        @Nullable
        private String customCacheKey;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(dataSourceFactory, new DefaultExtractorsFactory());
        }

        public Factory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
            this.dataSourceFactory = dataSourceFactory;
            this.extractorsFactory = extractorsFactory;
            this.mediaSourceDrmHelper = new MediaSourceDrmHelper();
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.continueLoadingCheckIntervalBytes = 0x100000;
        }

        @Deprecated
        public Factory setExtractorsFactory(@Nullable ExtractorsFactory extractorsFactory) {
            this.extractorsFactory = extractorsFactory != null ? extractorsFactory : new DefaultExtractorsFactory();
            return this;
        }

        @Deprecated
        public Factory setCustomCacheKey(@Nullable String customCacheKey) {
            this.customCacheKey = customCacheKey;
            return this;
        }

        @Deprecated
        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        public Factory setContinueLoadingCheckIntervalBytes(int continueLoadingCheckIntervalBytes) {
            this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
            return this;
        }

        @Override
        public Factory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
            this.drmSessionManager = drmSessionManager;
            return this;
        }

        @Override
        public Factory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
            this.mediaSourceDrmHelper.setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
            return this;
        }

        @Override
        public Factory setDrmUserAgent(@Nullable String userAgent) {
            this.mediaSourceDrmHelper.setDrmUserAgent(userAgent);
            return this;
        }

        @Override
        @Deprecated
        public ProgressiveMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).build());
        }

        @Override
        public ProgressiveMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsCustomCacheKey;
            Assertions.checkNotNull(mediaItem.playbackProperties);
            boolean needsTag = mediaItem.playbackProperties.tag == null && this.tag != null;
            boolean bl = needsCustomCacheKey = mediaItem.playbackProperties.customCacheKey == null && this.customCacheKey != null;
            if (needsTag && needsCustomCacheKey) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setCustomCacheKey(this.customCacheKey).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsCustomCacheKey) {
                mediaItem = mediaItem.buildUpon().setCustomCacheKey(this.customCacheKey).build();
            }
            return new ProgressiveMediaSource(mediaItem, this.dataSourceFactory, this.extractorsFactory, this.drmSessionManager != null ? this.drmSessionManager : this.mediaSourceDrmHelper.create(mediaItem), this.loadErrorHandlingPolicy, this.continueLoadingCheckIntervalBytes);
        }

        @Override
        public int[] getSupportedTypes() {
            return new int[]{3};
        }
    }
}

