/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.util.AtomicFile;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

@Deprecated
final class ActionFile {
    private static final int VERSION = 0;
    private static final String DOWNLOAD_TYPE_PROGRESSIVE = "progressive";
    private static final String DOWNLOAD_TYPE_DASH = "dash";
    private static final String DOWNLOAD_TYPE_HLS = "hls";
    private static final String DOWNLOAD_TYPE_SS = "ss";
    private final AtomicFile atomicFile;

    public ActionFile(File actionFile) {
        this.atomicFile = new AtomicFile(actionFile);
    }

    public boolean exists() {
        return this.atomicFile.exists();
    }

    public void delete() {
        this.atomicFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadRequest[] load() throws IOException {
        if (!this.exists()) {
            return new DownloadRequest[0];
        }
        InputStream inputStream = null;
        try {
            inputStream = this.atomicFile.openRead();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int version = dataInputStream.readInt();
            if (version > 0) {
                throw new IOException("Unsupported action file version: " + version);
            }
            int actionCount = dataInputStream.readInt();
            ArrayList<DownloadRequest> actions = new ArrayList<DownloadRequest>();
            for (int i = 0; i < actionCount; ++i) {
                try {
                    actions.add(ActionFile.readDownloadRequest(dataInputStream));
                    continue;
                }
                catch (DownloadRequest.UnsupportedRequestException unsupportedRequestException) {
                    // empty catch block
                }
            }
            DownloadRequest[] downloadRequestArray = actions.toArray(new DownloadRequest[0]);
            return downloadRequestArray;
        }
        finally {
            Util.closeQuietly(inputStream);
        }
    }

    private static DownloadRequest readDownloadRequest(DataInputStream input) throws IOException {
        String id;
        byte[] data;
        String downloadType = input.readUTF();
        int version = input.readInt();
        Uri uri = Uri.parse((String)input.readUTF());
        boolean isRemoveAction = input.readBoolean();
        int dataLength = input.readInt();
        if (dataLength != 0) {
            data = new byte[dataLength];
            input.readFully(data);
        } else {
            data = null;
        }
        boolean isLegacyProgressive = version == 0 && DOWNLOAD_TYPE_PROGRESSIVE.equals(downloadType);
        ArrayList<StreamKey> keys = new ArrayList<StreamKey>();
        if (!isLegacyProgressive) {
            int keyCount = input.readInt();
            for (int i = 0; i < keyCount; ++i) {
                keys.add(ActionFile.readKey(downloadType, version, input));
            }
        }
        boolean isLegacySegmented = version < 2 && (DOWNLOAD_TYPE_DASH.equals(downloadType) || DOWNLOAD_TYPE_HLS.equals(downloadType) || DOWNLOAD_TYPE_SS.equals(downloadType));
        String customCacheKey = null;
        if (!isLegacySegmented) {
            customCacheKey = input.readBoolean() ? input.readUTF() : null;
        }
        String string2 = id = version < 3 ? ActionFile.generateDownloadId(uri, customCacheKey) : input.readUTF();
        if (isRemoveAction) {
            throw new DownloadRequest.UnsupportedRequestException();
        }
        return new DownloadRequest.Builder(id, uri).setMimeType(ActionFile.inferMimeType(downloadType)).setStreamKeys(keys).setCustomCacheKey(customCacheKey).setData(data).build();
    }

    private static StreamKey readKey(String type, int version, DataInputStream input) throws IOException {
        int trackIndex;
        int groupIndex;
        int periodIndex;
        if ((DOWNLOAD_TYPE_HLS.equals(type) || DOWNLOAD_TYPE_SS.equals(type)) && version == 0) {
            periodIndex = 0;
            groupIndex = input.readInt();
            trackIndex = input.readInt();
        } else {
            periodIndex = input.readInt();
            groupIndex = input.readInt();
            trackIndex = input.readInt();
        }
        return new StreamKey(periodIndex, groupIndex, trackIndex);
    }

    private static String inferMimeType(String downloadType) {
        switch (downloadType) {
            case "dash": {
                return "application/dash+xml";
            }
            case "hls": {
                return "application/x-mpegURL";
            }
            case "ss": {
                return "application/vnd.ms-sstr+xml";
            }
        }
        return "video/x-unknown";
    }

    private static String generateDownloadId(Uri uri, @Nullable String customCacheKey) {
        return customCacheKey != null ? customCacheKey : uri.toString();
    }
}

