/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.util.IntArrayQueue;
import java.util.ArrayDeque;

@RequiresApi(value=21)
final class MediaCodecAsyncCallback
extends MediaCodec.Callback {
    private final IntArrayQueue availableInputBuffers = new IntArrayQueue();
    private final IntArrayQueue availableOutputBuffers = new IntArrayQueue();
    private final ArrayDeque<MediaCodec.BufferInfo> bufferInfos = new ArrayDeque();
    private final ArrayDeque<MediaFormat> formats = new ArrayDeque();
    @Nullable
    private MediaFormat currentFormat;
    @Nullable
    private MediaFormat pendingOutputFormat;
    @Nullable
    private IllegalStateException mediaCodecException;

    public int dequeueInputBufferIndex() {
        return this.availableInputBuffers.isEmpty() ? -1 : this.availableInputBuffers.remove();
    }

    public int dequeueOutputBufferIndex(MediaCodec.BufferInfo bufferInfo) {
        if (this.availableOutputBuffers.isEmpty()) {
            return -1;
        }
        int bufferIndex = this.availableOutputBuffers.remove();
        if (bufferIndex >= 0) {
            MediaCodec.BufferInfo nextBufferInfo = this.bufferInfos.remove();
            bufferInfo.set(nextBufferInfo.offset, nextBufferInfo.size, nextBufferInfo.presentationTimeUs, nextBufferInfo.flags);
        } else if (bufferIndex == -2) {
            this.currentFormat = this.formats.remove();
        }
        return bufferIndex;
    }

    public MediaFormat getOutputFormat() throws IllegalStateException {
        if (this.currentFormat == null) {
            throw new IllegalStateException();
        }
        return this.currentFormat;
    }

    public void maybeThrowMediaCodecException() throws IllegalStateException {
        IllegalStateException exception = this.mediaCodecException;
        this.mediaCodecException = null;
        if (exception != null) {
            throw exception;
        }
    }

    public void flush() {
        this.pendingOutputFormat = this.formats.isEmpty() ? null : this.formats.getLast();
        this.availableInputBuffers.clear();
        this.availableOutputBuffers.clear();
        this.bufferInfos.clear();
        this.formats.clear();
        this.mediaCodecException = null;
    }

    public void onInputBufferAvailable(MediaCodec mediaCodec, int index) {
        this.availableInputBuffers.add(index);
    }

    public void onOutputBufferAvailable(MediaCodec mediaCodec, int index, MediaCodec.BufferInfo bufferInfo) {
        if (this.pendingOutputFormat != null) {
            this.addOutputFormat(this.pendingOutputFormat);
            this.pendingOutputFormat = null;
        }
        this.availableOutputBuffers.add(index);
        this.bufferInfos.add(bufferInfo);
    }

    public void onError(MediaCodec mediaCodec, MediaCodec.CodecException e) {
        this.onMediaCodecError((IllegalStateException)e);
    }

    public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        this.addOutputFormat(mediaFormat);
        this.pendingOutputFormat = null;
    }

    @VisibleForTesting
    void onMediaCodecError(IllegalStateException e) {
        this.mediaCodecException = e;
    }

    private void addOutputFormat(MediaFormat mediaFormat) {
        this.availableOutputBuffers.add(-2);
        this.formats.add(mediaFormat);
    }
}

