/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.ogg;

import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.io.EOFException;
import java.io.IOException;

final class OggPageHeader {
    public static final int EMPTY_PAGE_HEADER_SIZE = 27;
    public static final int MAX_SEGMENT_COUNT = 255;
    public static final int MAX_PAGE_PAYLOAD = 65025;
    public static final int MAX_PAGE_SIZE = 65307;
    private static final int CAPTURE_PATTERN = 1332176723;
    private static final int CAPTURE_PATTERN_SIZE = 4;
    public int revision;
    public int type;
    public long granulePosition;
    public long streamSerialNumber;
    public long pageSequenceNumber;
    public long pageChecksum;
    public int pageSegmentCount;
    public int headerSize;
    public int bodySize;
    public final int[] laces = new int[255];
    private final ParsableByteArray scratch = new ParsableByteArray(255);

    OggPageHeader() {
    }

    public void reset() {
        this.revision = 0;
        this.type = 0;
        this.granulePosition = 0L;
        this.streamSerialNumber = 0L;
        this.pageSequenceNumber = 0L;
        this.pageChecksum = 0L;
        this.pageSegmentCount = 0;
        this.headerSize = 0;
        this.bodySize = 0;
    }

    public boolean skipToNextPage(ExtractorInput input) throws IOException {
        return this.skipToNextPage(input, -1L);
    }

    public boolean skipToNextPage(ExtractorInput input, long limit) throws IOException {
        Assertions.checkArgument(input.getPosition() == input.getPeekPosition());
        while ((limit == -1L || input.getPosition() + 4L < limit) && OggPageHeader.peekSafely(input, this.scratch.getData(), 0, 4, true)) {
            this.scratch.reset(4);
            if (this.scratch.readUnsignedInt() == 1332176723L) {
                input.resetPeekPosition();
                return true;
            }
            input.skipFully(1);
        }
        while ((limit == -1L || input.getPosition() < limit) && input.skip(1) != -1) {
        }
        return false;
    }

    public boolean populate(ExtractorInput input, boolean quiet) throws IOException {
        this.reset();
        this.scratch.reset(27);
        if (!OggPageHeader.peekSafely(input, this.scratch.getData(), 0, 27, quiet) || this.scratch.readUnsignedInt() != 1332176723L) {
            return false;
        }
        this.revision = this.scratch.readUnsignedByte();
        if (this.revision != 0) {
            if (quiet) {
                return false;
            }
            throw new ParserException("unsupported bit stream revision");
        }
        this.type = this.scratch.readUnsignedByte();
        this.granulePosition = this.scratch.readLittleEndianLong();
        this.streamSerialNumber = this.scratch.readLittleEndianUnsignedInt();
        this.pageSequenceNumber = this.scratch.readLittleEndianUnsignedInt();
        this.pageChecksum = this.scratch.readLittleEndianUnsignedInt();
        this.pageSegmentCount = this.scratch.readUnsignedByte();
        this.headerSize = 27 + this.pageSegmentCount;
        this.scratch.reset(this.pageSegmentCount);
        input.peekFully(this.scratch.getData(), 0, this.pageSegmentCount);
        for (int i = 0; i < this.pageSegmentCount; ++i) {
            this.laces[i] = this.scratch.readUnsignedByte();
            this.bodySize += this.laces[i];
        }
        return true;
    }

    private static boolean peekSafely(ExtractorInput input, byte[] output, int offset, int length, boolean quiet) throws IOException {
        try {
            return input.peekFully(output, offset, length, quiet);
        }
        catch (EOFException e) {
            if (quiet) {
                return false;
            }
            throw e;
        }
    }
}

