/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.mp3;

import android.util.Pair;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.extractor.SeekMap;
import com.akamai.amp.exoplayer2.extractor.SeekPoint;
import com.akamai.amp.exoplayer2.extractor.mp3.Seeker;
import com.akamai.amp.exoplayer2.metadata.id3.MlltFrame;
import com.akamai.amp.exoplayer2.util.Util;

final class MlltSeeker
implements Seeker {
    private final long[] referencePositions;
    private final long[] referenceTimesMs;
    private final long durationUs;

    public static MlltSeeker create(long firstFramePosition, MlltFrame mlltFrame, long durationUs) {
        int referenceCount = mlltFrame.bytesDeviations.length;
        long[] referencePositions = new long[1 + referenceCount];
        long[] referenceTimesMs = new long[1 + referenceCount];
        referencePositions[0] = firstFramePosition;
        referenceTimesMs[0] = 0L;
        long position = firstFramePosition;
        long timeMs = 0L;
        for (int i = 1; i <= referenceCount; ++i) {
            referencePositions[i] = position += (long)(mlltFrame.bytesBetweenReference + mlltFrame.bytesDeviations[i - 1]);
            referenceTimesMs[i] = timeMs += (long)(mlltFrame.millisecondsBetweenReference + mlltFrame.millisecondsDeviations[i - 1]);
        }
        return new MlltSeeker(referencePositions, referenceTimesMs, durationUs);
    }

    private MlltSeeker(long[] referencePositions, long[] referenceTimesMs, long durationUs) {
        this.referencePositions = referencePositions;
        this.referenceTimesMs = referenceTimesMs;
        this.durationUs = durationUs != -9223372036854775807L ? durationUs : C.msToUs(referenceTimesMs[referenceTimesMs.length - 1]);
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        timeUs = Util.constrainValue(timeUs, 0L, this.durationUs);
        Pair<Long, Long> timeMsAndPosition = MlltSeeker.linearlyInterpolate(C.usToMs(timeUs), this.referenceTimesMs, this.referencePositions);
        timeUs = C.msToUs((Long)timeMsAndPosition.first);
        long position = (Long)timeMsAndPosition.second;
        return new SeekMap.SeekPoints(new SeekPoint(timeUs, position));
    }

    @Override
    public long getTimeUs(long position) {
        Pair<Long, Long> positionAndTimeMs = MlltSeeker.linearlyInterpolate(position, this.referencePositions, this.referenceTimesMs);
        return C.msToUs((Long)positionAndTimeMs.second);
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    private static Pair<Long, Long> linearlyInterpolate(long x, long[] xReferences, long[] yReferences) {
        int previousReferenceIndex = Util.binarySearchFloor(xReferences, x, true, true);
        long xPreviousReference = xReferences[previousReferenceIndex];
        long yPreviousReference = yReferences[previousReferenceIndex];
        int nextReferenceIndex = previousReferenceIndex + 1;
        if (nextReferenceIndex == xReferences.length) {
            return Pair.create((Object)xPreviousReference, (Object)yPreviousReference);
        }
        long xNextReference = xReferences[nextReferenceIndex];
        long yNextReference = yReferences[nextReferenceIndex];
        double proportion = xNextReference == xPreviousReference ? 0.0 : ((double)x - (double)xPreviousReference) / (double)(xNextReference - xPreviousReference);
        long y = (long)(proportion * (double)(yNextReference - yPreviousReference)) + yPreviousReference;
        return Pair.create((Object)x, (Object)y);
    }

    @Override
    public long getDataEndPosition() {
        return -1L;
    }
}

