/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.BasePlayer;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.ExoPlayer;
import com.akamai.amp.exoplayer2.ExoPlayerImplInternal;
import com.akamai.amp.exoplayer2.ExoPlayerLibraryInfo;
import com.akamai.amp.exoplayer2.IllegalSeekPositionException;
import com.akamai.amp.exoplayer2.LoadControl;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.MediaSourceInfoHolder;
import com.akamai.amp.exoplayer2.MediaSourceList;
import com.akamai.amp.exoplayer2.PlaybackInfo;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.PlayerMessage;
import com.akamai.amp.exoplayer2.PlaylistTimeline;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RendererConfiguration;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.analytics.AnalyticsCollector;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.ShuffleOrder;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.source.ads.AdsMediaSource;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectorResult;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Clock;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;

final class ExoPlayerImpl
extends BasePlayer
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    final TrackSelectorResult emptyTrackSelectorResult;
    private final Renderer[] renderers;
    private final TrackSelector trackSelector;
    private final Handler playbackInfoUpdateHandler;
    private final ExoPlayerImplInternal.PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final ExoPlayerImplInternal internalPlayer;
    private final Handler internalPlayerHandler;
    private final CopyOnWriteArrayList<BasePlayer.ListenerHolder> listeners;
    private final Timeline.Period period;
    private final ArrayDeque<Runnable> pendingListenerNotifications;
    private final List<MediaSourceHolderSnapshot> mediaSourceHolderSnapshots;
    private final boolean useLazyPreparation;
    private final MediaSourceFactory mediaSourceFactory;
    @Nullable
    private final AnalyticsCollector analyticsCollector;
    private final Looper applicationLooper;
    private final BandwidthMeter bandwidthMeter;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private int pendingOperationAcks;
    private boolean hasPendingDiscontinuity;
    private int pendingDiscontinuityReason;
    private int pendingPlayWhenReadyChangeReason;
    private boolean foregroundMode;
    private SeekParameters seekParameters;
    private ShuffleOrder shuffleOrder;
    private boolean pauseAtEndOfMediaItems;
    private boolean hasAdsMediaSource;
    private PlaybackInfo playbackInfo;
    private int maskingWindowIndex;
    private int maskingPeriodIndex;
    private long maskingWindowPositionMs;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(Renderer[] renderers, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, @Nullable AnalyticsCollector analyticsCollector, boolean useLazyPreparation, SeekParameters seekParameters, boolean pauseAtEndOfMediaItems, Clock clock, Looper applicationLooper) {
        Log.i(TAG, "Init " + Integer.toHexString(System.identityHashCode(this)) + " [" + "ExoPlayerLib/2.12.3" + "] [" + Util.DEVICE_DEBUG_INFO + "]");
        Assertions.checkState(renderers.length > 0);
        this.renderers = Assertions.checkNotNull(renderers);
        this.trackSelector = Assertions.checkNotNull(trackSelector);
        this.mediaSourceFactory = mediaSourceFactory;
        this.bandwidthMeter = bandwidthMeter;
        this.analyticsCollector = analyticsCollector;
        this.useLazyPreparation = useLazyPreparation;
        this.seekParameters = seekParameters;
        this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
        this.applicationLooper = applicationLooper;
        this.repeatMode = 0;
        this.listeners = new CopyOnWriteArrayList();
        this.mediaSourceHolderSnapshots = new ArrayList<MediaSourceHolderSnapshot>();
        this.shuffleOrder = new ShuffleOrder.DefaultShuffleOrder(0);
        this.emptyTrackSelectorResult = new TrackSelectorResult(new RendererConfiguration[renderers.length], new TrackSelection[renderers.length], null);
        this.period = new Timeline.Period();
        this.maskingWindowIndex = -1;
        this.playbackInfoUpdateHandler = new Handler(applicationLooper);
        this.playbackInfoUpdateListener = playbackInfoUpdate -> this.playbackInfoUpdateHandler.post(() -> this.handlePlaybackInfo(playbackInfoUpdate));
        this.playbackInfo = PlaybackInfo.createDummy(this.emptyTrackSelectorResult);
        this.pendingListenerNotifications = new ArrayDeque();
        if (analyticsCollector != null) {
            analyticsCollector.setPlayer(this);
            this.addListener(analyticsCollector);
            bandwidthMeter.addEventListener(new Handler(applicationLooper), analyticsCollector);
        }
        this.internalPlayer = new ExoPlayerImplInternal(renderers, trackSelector, this.emptyTrackSelectorResult, loadControl, bandwidthMeter, this.repeatMode, this.shuffleModeEnabled, analyticsCollector, seekParameters, pauseAtEndOfMediaItems, applicationLooper, clock, this.playbackInfoUpdateListener);
        this.internalPlayerHandler = new Handler(this.internalPlayer.getPlaybackLooper());
    }

    public void experimentalSetReleaseTimeoutMs(long timeoutMs) {
        this.internalPlayer.experimentalSetReleaseTimeoutMs(timeoutMs);
    }

    public void experimentalDisableThrowWhenStuckBuffering() {
        this.internalPlayer.experimentalDisableThrowWhenStuckBuffering();
    }

    @Override
    public void experimentalSetOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        this.internalPlayer.experimentalSetOffloadSchedulingEnabled(offloadSchedulingEnabled);
    }

    @Override
    @Nullable
    public Player.AudioComponent getAudioComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.VideoComponent getVideoComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.TextComponent getTextComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.MetadataComponent getMetadataComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.DeviceComponent getDeviceComponent() {
        return null;
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    @Override
    public Looper getApplicationLooper() {
        return this.applicationLooper;
    }

    @Override
    public void addListener(Player.EventListener listener) {
        Assertions.checkNotNull(listener);
        this.listeners.addIfAbsent(new BasePlayer.ListenerHolder(listener));
    }

    @Override
    public void removeListener(Player.EventListener listener) {
        for (BasePlayer.ListenerHolder listenerHolder : this.listeners) {
            if (!listenerHolder.listener.equals(listener)) continue;
            listenerHolder.release();
            this.listeners.remove(listenerHolder);
        }
    }

    @Override
    public int getPlaybackState() {
        return this.playbackInfo.playbackState;
    }

    @Override
    public int getPlaybackSuppressionReason() {
        return this.playbackInfo.playbackSuppressionReason;
    }

    @Override
    @Deprecated
    @Nullable
    public ExoPlaybackException getPlaybackError() {
        return this.getPlayerError();
    }

    @Override
    @Nullable
    public ExoPlaybackException getPlayerError() {
        return this.playbackInfo.playbackError;
    }

    @Override
    @Deprecated
    public void retry() {
        this.prepare();
    }

    @Override
    public void prepare() {
        if (this.playbackInfo.playbackState != 1) {
            return;
        }
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlaybackError(null);
        playbackInfo = playbackInfo.copyWithPlaybackState(playbackInfo.timeline.isEmpty() ? 4 : 2);
        ++this.pendingOperationAcks;
        this.internalPlayer.prepare();
        this.updatePlaybackInfo(playbackInfo, false, 4, 1, 1, false);
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.setMediaSource(mediaSource);
        this.prepare();
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.setMediaSource(mediaSource, resetPosition);
        this.prepare();
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.setMediaSources(this.createMediaSources(mediaItems), resetPosition);
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems, int startWindowIndex, long startPositionMs) {
        this.setMediaSources(this.createMediaSources(mediaItems), startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource) {
        this.setMediaSources(Collections.singletonList(mediaSource));
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, long startPositionMs) {
        this.setMediaSources(Collections.singletonList(mediaSource), 0, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, boolean resetPosition) {
        this.setMediaSources(Collections.singletonList(mediaSource), resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources) {
        this.setMediaSources(mediaSources, true);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, boolean resetPosition) {
        this.setMediaSourcesInternal(mediaSources, -1, -9223372036854775807L, resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs) {
        this.setMediaSourcesInternal(mediaSources, startWindowIndex, startPositionMs, false);
    }

    @Override
    public void addMediaItems(List<MediaItem> mediaItems) {
        this.addMediaItems(this.mediaSourceHolderSnapshots.size(), mediaItems);
    }

    @Override
    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        this.addMediaSources(index, this.createMediaSources(mediaItems));
    }

    @Override
    public void addMediaSource(MediaSource mediaSource) {
        this.addMediaSources(Collections.singletonList(mediaSource));
    }

    @Override
    public void addMediaSource(int index, MediaSource mediaSource) {
        this.addMediaSources(index, Collections.singletonList(mediaSource));
    }

    @Override
    public void addMediaSources(List<MediaSource> mediaSources) {
        this.addMediaSources(this.mediaSourceHolderSnapshots.size(), mediaSources);
    }

    @Override
    public void addMediaSources(int index, List<MediaSource> mediaSources) {
        Assertions.checkArgument(index >= 0);
        this.validateMediaSources(mediaSources, false);
        Timeline oldTimeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        List<MediaSourceList.MediaSourceHolder> holders = this.addMediaSourceHolders(index, mediaSources);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionAfterTimelineChanged(oldTimeline, newTimeline));
        this.internalPlayer.addMediaSources(index, holders, this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, false, 4, 0, 1, false);
    }

    @Override
    public void removeMediaItems(int fromIndex, int toIndex) {
        PlaybackInfo playbackInfo = this.removeMediaItemsInternal(fromIndex, toIndex);
        this.updatePlaybackInfo(playbackInfo, false, 4, 0, 1, false);
    }

    @Override
    public void moveMediaItems(int fromIndex, int toIndex, int newFromIndex) {
        Assertions.checkArgument(fromIndex >= 0 && fromIndex <= toIndex && toIndex <= this.mediaSourceHolderSnapshots.size() && newFromIndex >= 0);
        Timeline oldTimeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        newFromIndex = Math.min(newFromIndex, this.mediaSourceHolderSnapshots.size() - (toIndex - fromIndex));
        Util.moveItems(this.mediaSourceHolderSnapshots, fromIndex, toIndex, newFromIndex);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionAfterTimelineChanged(oldTimeline, newTimeline));
        this.internalPlayer.moveMediaSources(fromIndex, toIndex, newFromIndex, this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, false, 4, 0, 1, false);
    }

    @Override
    public void clearMediaItems() {
        this.removeMediaItems(0, this.mediaSourceHolderSnapshots.size());
    }

    @Override
    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        Timeline timeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, this.getCurrentWindowIndex(), this.getCurrentPosition()));
        ++this.pendingOperationAcks;
        this.shuffleOrder = shuffleOrder;
        this.internalPlayer.setShuffleOrder(shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, false, 4, 0, 1, false);
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.setPlayWhenReady(playWhenReady, 0, 1);
    }

    @Override
    public void setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
        if (this.pauseAtEndOfMediaItems == pauseAtEndOfMediaItems) {
            return;
        }
        this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
        this.internalPlayer.setPauseAtEndOfWindow(pauseAtEndOfMediaItems);
    }

    @Override
    public boolean getPauseAtEndOfMediaItems() {
        return this.pauseAtEndOfMediaItems;
    }

    public void setPlayWhenReady(boolean playWhenReady, int playbackSuppressionReason, int playWhenReadyChangeReason) {
        if (this.playbackInfo.playWhenReady == playWhenReady && this.playbackInfo.playbackSuppressionReason == playbackSuppressionReason) {
            return;
        }
        ++this.pendingOperationAcks;
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.internalPlayer.setPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.updatePlaybackInfo(playbackInfo, false, 4, 0, playWhenReadyChangeReason, false);
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.playbackInfo.playWhenReady;
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        if (this.repeatMode != repeatMode) {
            this.repeatMode = repeatMode;
            this.internalPlayer.setRepeatMode(repeatMode);
            this.notifyListeners((Player.EventListener listener) -> listener.onRepeatModeChanged(repeatMode));
        }
    }

    @Override
    public int getRepeatMode() {
        return this.repeatMode;
    }

    @Override
    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        if (this.shuffleModeEnabled != shuffleModeEnabled) {
            this.shuffleModeEnabled = shuffleModeEnabled;
            this.internalPlayer.setShuffleModeEnabled(shuffleModeEnabled);
            this.notifyListeners((Player.EventListener listener) -> listener.onShuffleModeEnabledChanged(shuffleModeEnabled));
        }
    }

    @Override
    public boolean getShuffleModeEnabled() {
        return this.shuffleModeEnabled;
    }

    @Override
    public boolean isLoading() {
        return this.playbackInfo.isLoading;
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        Timeline timeline = this.playbackInfo.timeline;
        if (windowIndex < 0 || !timeline.isEmpty() && windowIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, windowIndex, positionMs);
        }
        ++this.pendingOperationAcks;
        if (this.isPlayingAd()) {
            Log.w(TAG, "seekTo ignored because an ad is playing");
            ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate = new ExoPlayerImplInternal.PlaybackInfoUpdate(this.playbackInfo);
            playbackInfoUpdate.incrementPendingOperationAcks(1);
            this.playbackInfoUpdateListener.onPlaybackInfoUpdate(playbackInfoUpdate);
            return;
        }
        int newPlaybackState = this.getPlaybackState() == 1 ? 1 : 2;
        PlaybackInfo newPlaybackInfo = this.playbackInfo.copyWithPlaybackState(newPlaybackState);
        newPlaybackInfo = this.maskTimelineAndPosition(newPlaybackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, windowIndex, positionMs));
        this.internalPlayer.seekTo(timeline, windowIndex, C.msToUs(positionMs));
        this.updatePlaybackInfo(newPlaybackInfo, true, 1, 0, 1, true);
    }

    @Override
    public void setPlaybackParameters(@Nullable PlaybackParameters playbackParameters) {
        if (playbackParameters == null) {
            playbackParameters = PlaybackParameters.DEFAULT;
        }
        if (this.playbackInfo.playbackParameters.equals(playbackParameters)) {
            return;
        }
        PlaybackInfo newPlaybackInfo = this.playbackInfo.copyWithPlaybackParameters(playbackParameters);
        ++this.pendingOperationAcks;
        this.internalPlayer.setPlaybackParameters(playbackParameters);
        this.updatePlaybackInfo(newPlaybackInfo, false, 4, 0, 1, false);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.playbackInfo.playbackParameters;
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        if (seekParameters == null) {
            seekParameters = SeekParameters.DEFAULT;
        }
        if (!this.seekParameters.equals(seekParameters)) {
            this.seekParameters = seekParameters;
            this.internalPlayer.setSeekParameters(seekParameters);
        }
    }

    @Override
    public SeekParameters getSeekParameters() {
        return this.seekParameters;
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            if (!this.internalPlayer.setForegroundMode(foregroundMode)) {
                this.notifyListeners((Player.EventListener listener) -> listener.onPlayerError(ExoPlaybackException.createForTimeout(new TimeoutException("Setting foreground mode timed out."), 2)));
            }
        }
    }

    @Override
    public void stop(boolean reset) {
        PlaybackInfo playbackInfo;
        if (reset) {
            playbackInfo = this.removeMediaItemsInternal(0, this.mediaSourceHolderSnapshots.size());
            playbackInfo = playbackInfo.copyWithPlaybackError(null);
        } else {
            playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(this.playbackInfo.periodId);
            playbackInfo.bufferedPositionUs = playbackInfo.positionUs;
            playbackInfo.totalBufferedDurationUs = 0L;
        }
        playbackInfo = playbackInfo.copyWithPlaybackState(1);
        ++this.pendingOperationAcks;
        this.internalPlayer.stop();
        this.updatePlaybackInfo(playbackInfo, false, 4, 0, 1, false);
    }

    @Override
    public void release() {
        Log.i(TAG, "Release " + Integer.toHexString(System.identityHashCode(this)) + " [" + "ExoPlayerLib/2.12.3" + "] [" + Util.DEVICE_DEBUG_INFO + "] [" + ExoPlayerLibraryInfo.registeredModules() + "]");
        if (!this.internalPlayer.release()) {
            this.notifyListeners((Player.EventListener listener) -> listener.onPlayerError(ExoPlaybackException.createForTimeout(new TimeoutException("Player release timed out."), 1)));
        }
        this.playbackInfoUpdateHandler.removeCallbacksAndMessages(null);
        if (this.analyticsCollector != null) {
            this.bandwidthMeter.removeEventListener(this.analyticsCollector);
        }
        this.playbackInfo = this.playbackInfo.copyWithPlaybackState(1);
        this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(this.playbackInfo.periodId);
        this.playbackInfo.bufferedPositionUs = this.playbackInfo.positionUs;
        this.playbackInfo.totalBufferedDurationUs = 0L;
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        return new PlayerMessage(this.internalPlayer, target, this.playbackInfo.timeline, this.getCurrentWindowIndex(), this.internalPlayerHandler);
    }

    @Override
    public int getCurrentPeriodIndex() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingPeriodIndex;
        }
        return this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
    }

    @Override
    public int getCurrentWindowIndex() {
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        return currentWindowIndex == -1 ? 0 : currentWindowIndex;
    }

    @Override
    public long getDuration() {
        if (this.isPlayingAd()) {
            MediaSource.MediaPeriodId periodId = this.playbackInfo.periodId;
            this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
            long adDurationUs = this.period.getAdDurationUs(periodId.adGroupIndex, periodId.adIndexInAdGroup);
            return C.usToMs(adDurationUs);
        }
        return this.getContentDuration();
    }

    @Override
    public long getCurrentPosition() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.periodId.isAd()) {
            return C.usToMs(this.playbackInfo.positionUs);
        }
        return this.periodPositionUsToWindowPositionMs(this.playbackInfo.periodId, this.playbackInfo.positionUs);
    }

    @Override
    public long getBufferedPosition() {
        if (this.isPlayingAd()) {
            return this.playbackInfo.loadingMediaPeriodId.equals(this.playbackInfo.periodId) ? C.usToMs(this.playbackInfo.bufferedPositionUs) : this.getDuration();
        }
        return this.getContentBufferedPosition();
    }

    @Override
    public long getTotalBufferedDuration() {
        return C.usToMs(this.playbackInfo.totalBufferedDurationUs);
    }

    @Override
    public boolean isPlayingAd() {
        return this.playbackInfo.periodId.isAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.isPlayingAd() ? this.playbackInfo.periodId.adGroupIndex : -1;
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.isPlayingAd() ? this.playbackInfo.periodId.adIndexInAdGroup : -1;
    }

    @Override
    public long getContentPosition() {
        if (this.isPlayingAd()) {
            this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.periodId.periodUid, this.period);
            return this.playbackInfo.requestedContentPositionUs == -9223372036854775807L ? this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDefaultPositionMs() : this.period.getPositionInWindowMs() + C.usToMs(this.playbackInfo.requestedContentPositionUs);
        }
        return this.getCurrentPosition();
    }

    @Override
    public long getContentBufferedPosition() {
        Timeline.Period loadingPeriod;
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.loadingMediaPeriodId.windowSequenceNumber != this.playbackInfo.periodId.windowSequenceNumber) {
            return this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
        }
        long contentBufferedPositionUs = this.playbackInfo.bufferedPositionUs;
        if (this.playbackInfo.loadingMediaPeriodId.isAd() && (contentBufferedPositionUs = (loadingPeriod = this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.loadingMediaPeriodId.periodUid, this.period)).getAdGroupTimeUs(this.playbackInfo.loadingMediaPeriodId.adGroupIndex)) == Long.MIN_VALUE) {
            contentBufferedPositionUs = loadingPeriod.durationUs;
        }
        return this.periodPositionUsToWindowPositionMs(this.playbackInfo.loadingMediaPeriodId, contentBufferedPositionUs);
    }

    @Override
    public int getRendererCount() {
        return this.renderers.length;
    }

    @Override
    public int getRendererType(int index) {
        return this.renderers[index].getTrackType();
    }

    @Override
    @Nullable
    public TrackSelector getTrackSelector() {
        return this.trackSelector;
    }

    @Override
    public TrackGroupArray getCurrentTrackGroups() {
        return this.playbackInfo.trackGroups;
    }

    @Override
    public TrackSelectionArray getCurrentTrackSelections() {
        return this.playbackInfo.trackSelectorResult.selections;
    }

    @Override
    public Timeline getCurrentTimeline() {
        return this.playbackInfo.timeline;
    }

    private int getCurrentWindowIndexInternal() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowIndex;
        }
        return this.playbackInfo.timeline.getPeriodByUid((Object)this.playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
    }

    private List<MediaSource> createMediaSources(List<MediaItem> mediaItems) {
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        for (int i = 0; i < mediaItems.size(); ++i) {
            mediaSources.add(this.mediaSourceFactory.createMediaSource(mediaItems.get(i)));
        }
        return mediaSources;
    }

    private void handlePlaybackInfo(ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate) {
        this.pendingOperationAcks -= playbackInfoUpdate.operationAcks;
        if (playbackInfoUpdate.positionDiscontinuity) {
            this.hasPendingDiscontinuity = true;
            this.pendingDiscontinuityReason = playbackInfoUpdate.discontinuityReason;
        }
        if (playbackInfoUpdate.hasPlayWhenReadyChangeReason) {
            this.pendingPlayWhenReadyChangeReason = playbackInfoUpdate.playWhenReadyChangeReason;
        }
        if (this.pendingOperationAcks == 0) {
            Timeline newTimeline = playbackInfoUpdate.playbackInfo.timeline;
            if (!this.playbackInfo.timeline.isEmpty() && newTimeline.isEmpty()) {
                this.maskingWindowIndex = -1;
                this.maskingWindowPositionMs = 0L;
                this.maskingPeriodIndex = 0;
            }
            if (!newTimeline.isEmpty()) {
                List<Timeline> timelines = ((PlaylistTimeline)newTimeline).getChildTimelines();
                Assertions.checkState(timelines.size() == this.mediaSourceHolderSnapshots.size());
                for (int i = 0; i < timelines.size(); ++i) {
                    this.mediaSourceHolderSnapshots.get((int)i).timeline = timelines.get(i);
                }
            }
            boolean positionDiscontinuity = this.hasPendingDiscontinuity;
            this.hasPendingDiscontinuity = false;
            this.updatePlaybackInfo(playbackInfoUpdate.playbackInfo, positionDiscontinuity, this.pendingDiscontinuityReason, 1, this.pendingPlayWhenReadyChangeReason, false);
        }
    }

    private void updatePlaybackInfo(PlaybackInfo playbackInfo, boolean positionDiscontinuity, int positionDiscontinuityReason, int timelineChangeReason, int playWhenReadyChangeReason, boolean seekProcessed) {
        PlaybackInfo previousPlaybackInfo = this.playbackInfo;
        this.playbackInfo = playbackInfo;
        Pair<Boolean, Integer> mediaItemTransitionInfo = this.evaluateMediaItemTransitionReason(playbackInfo, previousPlaybackInfo, positionDiscontinuity, positionDiscontinuityReason, !previousPlaybackInfo.timeline.equals(playbackInfo.timeline));
        boolean mediaItemTransitioned = (Boolean)mediaItemTransitionInfo.first;
        int mediaItemTransitionReason = (Integer)mediaItemTransitionInfo.second;
        MediaItem newMediaItem = null;
        if (mediaItemTransitioned && !playbackInfo.timeline.isEmpty()) {
            int windowIndex = playbackInfo.timeline.getPeriodByUid((Object)playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
            newMediaItem = playbackInfo.timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).mediaItem;
        }
        this.notifyListeners(new PlaybackInfoUpdate(playbackInfo, previousPlaybackInfo, this.listeners, this.trackSelector, positionDiscontinuity, positionDiscontinuityReason, timelineChangeReason, mediaItemTransitioned, mediaItemTransitionReason, newMediaItem, playWhenReadyChangeReason, seekProcessed));
    }

    private Pair<Boolean, Integer> evaluateMediaItemTransitionReason(PlaybackInfo playbackInfo, PlaybackInfo oldPlaybackInfo, boolean positionDiscontinuity, int positionDiscontinuityReason, boolean timelineChanged) {
        Timeline oldTimeline = oldPlaybackInfo.timeline;
        Timeline newTimeline = playbackInfo.timeline;
        if (newTimeline.isEmpty() && oldTimeline.isEmpty()) {
            return new Pair((Object)false, (Object)-1);
        }
        if (newTimeline.isEmpty() != oldTimeline.isEmpty()) {
            return new Pair((Object)true, (Object)3);
        }
        int oldWindowIndex = oldTimeline.getPeriodByUid((Object)oldPlaybackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
        Object oldWindowUid = oldTimeline.getWindow((int)oldWindowIndex, (Timeline.Window)this.window).uid;
        int newWindowIndex = newTimeline.getPeriodByUid((Object)playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
        Object newWindowUid = newTimeline.getWindow((int)newWindowIndex, (Timeline.Window)this.window).uid;
        int firstPeriodIndexInNewWindow = this.window.firstPeriodIndex;
        if (!oldWindowUid.equals(newWindowUid)) {
            int transitionReason;
            if (positionDiscontinuity && positionDiscontinuityReason == 0) {
                transitionReason = 1;
            } else if (positionDiscontinuity && positionDiscontinuityReason == 1) {
                transitionReason = 2;
            } else if (timelineChanged) {
                transitionReason = 3;
            } else {
                throw new IllegalStateException();
            }
            return new Pair((Object)true, (Object)transitionReason);
        }
        if (positionDiscontinuity && positionDiscontinuityReason == 0 && newTimeline.getIndexOfPeriod(playbackInfo.periodId.periodUid) == firstPeriodIndexInNewWindow) {
            return new Pair((Object)true, (Object)0);
        }
        return new Pair((Object)false, (Object)-1);
    }

    private void setMediaSourcesInternal(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs, boolean resetToDefaultPosition) {
        this.validateMediaSources(mediaSources, true);
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        long currentPositionMs = this.getCurrentPosition();
        ++this.pendingOperationAcks;
        if (!this.mediaSourceHolderSnapshots.isEmpty()) {
            this.removeMediaSourceHolders(0, this.mediaSourceHolderSnapshots.size());
        }
        List<MediaSourceList.MediaSourceHolder> holders = this.addMediaSourceHolders(0, mediaSources);
        Timeline timeline = this.createMaskingTimeline();
        if (!timeline.isEmpty() && startWindowIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, startWindowIndex, startPositionMs);
        }
        if (resetToDefaultPosition) {
            startWindowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            startPositionMs = -9223372036854775807L;
        } else if (startWindowIndex == -1) {
            startWindowIndex = currentWindowIndex;
            startPositionMs = currentPositionMs;
        }
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, startWindowIndex, startPositionMs));
        int maskingPlaybackState = newPlaybackInfo.playbackState;
        if (startWindowIndex != -1 && newPlaybackInfo.playbackState != 1) {
            maskingPlaybackState = timeline.isEmpty() || startWindowIndex >= timeline.getWindowCount() ? 4 : 2;
        }
        newPlaybackInfo = newPlaybackInfo.copyWithPlaybackState(maskingPlaybackState);
        this.internalPlayer.setMediaSources(holders, startWindowIndex, C.msToUs(startPositionMs), this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, false, 4, 0, 1, false);
    }

    private List<MediaSourceList.MediaSourceHolder> addMediaSourceHolders(int index, List<MediaSource> mediaSources) {
        ArrayList<MediaSourceList.MediaSourceHolder> holders = new ArrayList<MediaSourceList.MediaSourceHolder>();
        for (int i = 0; i < mediaSources.size(); ++i) {
            MediaSourceList.MediaSourceHolder holder = new MediaSourceList.MediaSourceHolder(mediaSources.get(i), this.useLazyPreparation);
            holders.add(holder);
            this.mediaSourceHolderSnapshots.add(i + index, new MediaSourceHolderSnapshot(holder.uid, holder.mediaSource.getTimeline()));
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndInsert(index, holders.size());
        return holders;
    }

    private PlaybackInfo removeMediaItemsInternal(int fromIndex, int toIndex) {
        boolean transitionsToEnded;
        Assertions.checkArgument(fromIndex >= 0 && toIndex >= fromIndex && toIndex <= this.mediaSourceHolderSnapshots.size());
        int currentWindowIndex = this.getCurrentWindowIndex();
        Timeline oldTimeline = this.getCurrentTimeline();
        int currentMediaSourceCount = this.mediaSourceHolderSnapshots.size();
        ++this.pendingOperationAcks;
        this.removeMediaSourceHolders(fromIndex, toIndex);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionAfterTimelineChanged(oldTimeline, newTimeline));
        boolean bl = transitionsToEnded = newPlaybackInfo.playbackState != 1 && newPlaybackInfo.playbackState != 4 && fromIndex < toIndex && toIndex == currentMediaSourceCount && currentWindowIndex >= newPlaybackInfo.timeline.getWindowCount();
        if (transitionsToEnded) {
            newPlaybackInfo = newPlaybackInfo.copyWithPlaybackState(4);
        }
        this.internalPlayer.removeMediaSources(fromIndex, toIndex, this.shuffleOrder);
        return newPlaybackInfo;
    }

    private void removeMediaSourceHolders(int fromIndex, int toIndexExclusive) {
        for (int i = toIndexExclusive - 1; i >= fromIndex; --i) {
            this.mediaSourceHolderSnapshots.remove(i);
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndRemove(fromIndex, toIndexExclusive);
        if (this.mediaSourceHolderSnapshots.isEmpty()) {
            this.hasAdsMediaSource = false;
        }
    }

    private void validateMediaSources(List<MediaSource> mediaSources, boolean mediaSourceReplacement) {
        if (this.hasAdsMediaSource && !mediaSourceReplacement && !mediaSources.isEmpty()) {
            throw new IllegalStateException();
        }
        int sizeAfterModification = mediaSources.size() + (mediaSourceReplacement ? 0 : this.mediaSourceHolderSnapshots.size());
        for (int i = 0; i < mediaSources.size(); ++i) {
            MediaSource mediaSource = Assertions.checkNotNull(mediaSources.get(i));
            if (!(mediaSource instanceof AdsMediaSource)) continue;
            if (sizeAfterModification > 1) {
                throw new IllegalArgumentException();
            }
            this.hasAdsMediaSource = true;
        }
    }

    private Timeline createMaskingTimeline() {
        return new PlaylistTimeline(this.mediaSourceHolderSnapshots, this.shuffleOrder);
    }

    private PlaybackInfo maskTimelineAndPosition(PlaybackInfo playbackInfo, Timeline timeline, @Nullable Pair<Object, Long> periodPosition) {
        Assertions.checkArgument(timeline.isEmpty() || periodPosition != null);
        Timeline oldTimeline = playbackInfo.timeline;
        playbackInfo = playbackInfo.copyWithTimeline(timeline);
        if (timeline.isEmpty()) {
            MediaSource.MediaPeriodId dummyMediaPeriodId = PlaybackInfo.getDummyPeriodForEmptyTimeline();
            playbackInfo = playbackInfo.copyWithNewPosition(dummyMediaPeriodId, C.msToUs(this.maskingWindowPositionMs), C.msToUs(this.maskingWindowPositionMs), 0L, TrackGroupArray.EMPTY, this.emptyTrackSelectorResult);
            playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(dummyMediaPeriodId);
            playbackInfo.bufferedPositionUs = playbackInfo.positionUs;
            return playbackInfo;
        }
        Object oldPeriodUid = playbackInfo.periodId.periodUid;
        boolean playingPeriodChanged = !oldPeriodUid.equals(Util.castNonNull(periodPosition).first);
        MediaSource.MediaPeriodId newPeriodId = playingPeriodChanged ? new MediaSource.MediaPeriodId(periodPosition.first) : playbackInfo.periodId;
        long newContentPositionUs = (Long)periodPosition.second;
        long oldContentPositionUs = C.msToUs(this.getContentPosition());
        if (!oldTimeline.isEmpty()) {
            oldContentPositionUs -= oldTimeline.getPeriodByUid(oldPeriodUid, this.period).getPositionInWindowUs();
        }
        if (playingPeriodChanged || newContentPositionUs < oldContentPositionUs) {
            Assertions.checkState(!newPeriodId.isAd());
            playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, newContentPositionUs, newContentPositionUs, 0L, playingPeriodChanged ? TrackGroupArray.EMPTY : playbackInfo.trackGroups, playingPeriodChanged ? this.emptyTrackSelectorResult : playbackInfo.trackSelectorResult);
            playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(newPeriodId);
            playbackInfo.bufferedPositionUs = newContentPositionUs;
        } else if (newContentPositionUs == oldContentPositionUs) {
            int loadingPeriodIndex = timeline.getIndexOfPeriod(playbackInfo.loadingMediaPeriodId.periodUid);
            if (loadingPeriodIndex == -1 || timeline.getPeriod((int)loadingPeriodIndex, (Timeline.Period)this.period).windowIndex != timeline.getPeriodByUid((Object)newPeriodId.periodUid, (Timeline.Period)this.period).windowIndex) {
                timeline.getPeriodByUid(newPeriodId.periodUid, this.period);
                long maskedBufferedPositionUs = newPeriodId.isAd() ? this.period.getAdDurationUs(newPeriodId.adGroupIndex, newPeriodId.adIndexInAdGroup) : this.period.durationUs;
                playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, playbackInfo.positionUs, playbackInfo.positionUs, maskedBufferedPositionUs - playbackInfo.positionUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult);
                playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(newPeriodId);
                playbackInfo.bufferedPositionUs = maskedBufferedPositionUs;
            }
        } else {
            Assertions.checkState(!newPeriodId.isAd());
            long maskedTotalBufferedDurationUs = Math.max(0L, playbackInfo.totalBufferedDurationUs - (newContentPositionUs - oldContentPositionUs));
            long maskedBufferedPositionUs = playbackInfo.bufferedPositionUs;
            if (playbackInfo.loadingMediaPeriodId.equals(playbackInfo.periodId)) {
                maskedBufferedPositionUs = newContentPositionUs + maskedTotalBufferedDurationUs;
            }
            playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, newContentPositionUs, newContentPositionUs, maskedTotalBufferedDurationUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult);
            playbackInfo.bufferedPositionUs = maskedBufferedPositionUs;
        }
        return playbackInfo;
    }

    @Nullable
    private Pair<Object, Long> getPeriodPositionAfterTimelineChanged(Timeline oldTimeline, Timeline newTimeline) {
        long currentPositionMs = this.getContentPosition();
        if (oldTimeline.isEmpty() || newTimeline.isEmpty()) {
            boolean isCleared = !oldTimeline.isEmpty() && newTimeline.isEmpty();
            return this.getPeriodPositionOrMaskWindowPosition(newTimeline, isCleared ? -1 : this.getCurrentWindowIndexInternal(), isCleared ? -9223372036854775807L : currentPositionMs);
        }
        int currentWindowIndex = this.getCurrentWindowIndex();
        Pair<Object, Long> oldPeriodPosition = oldTimeline.getPeriodPosition(this.window, this.period, currentWindowIndex, C.msToUs(currentPositionMs));
        Object periodUid = Util.castNonNull(oldPeriodPosition).first;
        if (newTimeline.getIndexOfPeriod(periodUid) != -1) {
            return oldPeriodPosition;
        }
        Object nextPeriodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(this.window, this.period, this.repeatMode, this.shuffleModeEnabled, periodUid, oldTimeline, newTimeline);
        if (nextPeriodUid != null) {
            newTimeline.getPeriodByUid(nextPeriodUid, this.period);
            return this.getPeriodPositionOrMaskWindowPosition(newTimeline, this.period.windowIndex, newTimeline.getWindow(this.period.windowIndex, this.window).getDefaultPositionMs());
        }
        return this.getPeriodPositionOrMaskWindowPosition(newTimeline, -1, -9223372036854775807L);
    }

    @Nullable
    private Pair<Object, Long> getPeriodPositionOrMaskWindowPosition(Timeline timeline, int windowIndex, long windowPositionMs) {
        if (timeline.isEmpty()) {
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = windowPositionMs == -9223372036854775807L ? 0L : windowPositionMs;
            this.maskingPeriodIndex = 0;
            return null;
        }
        if (windowIndex == -1 || windowIndex >= timeline.getWindowCount()) {
            windowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            windowPositionMs = timeline.getWindow(windowIndex, this.window).getDefaultPositionMs();
        }
        return timeline.getPeriodPosition(this.window, this.period, windowIndex, C.msToUs(windowPositionMs));
    }

    private void notifyListeners(BasePlayer.ListenerInvocation listenerInvocation) {
        CopyOnWriteArrayList<BasePlayer.ListenerHolder> listenerSnapshot = new CopyOnWriteArrayList<BasePlayer.ListenerHolder>(this.listeners);
        this.notifyListeners(() -> ExoPlayerImpl.invokeAll(listenerSnapshot, listenerInvocation));
    }

    private void notifyListeners(Runnable listenerNotificationRunnable) {
        boolean isRunningRecursiveListenerNotification = !this.pendingListenerNotifications.isEmpty();
        this.pendingListenerNotifications.addLast(listenerNotificationRunnable);
        if (isRunningRecursiveListenerNotification) {
            return;
        }
        while (!this.pendingListenerNotifications.isEmpty()) {
            this.pendingListenerNotifications.peekFirst().run();
            this.pendingListenerNotifications.removeFirst();
        }
    }

    private long periodPositionUsToWindowPositionMs(MediaSource.MediaPeriodId periodId, long positionUs) {
        long positionMs = C.usToMs(positionUs);
        this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
        return positionMs += this.period.getPositionInWindowMs();
    }

    private static void invokeAll(CopyOnWriteArrayList<BasePlayer.ListenerHolder> listeners, BasePlayer.ListenerInvocation listenerInvocation) {
        for (BasePlayer.ListenerHolder listenerHolder : listeners) {
            listenerHolder.invoke(listenerInvocation);
        }
    }

    private static final class MediaSourceHolderSnapshot
    implements MediaSourceInfoHolder {
        private final Object uid;
        private Timeline timeline;

        public MediaSourceHolderSnapshot(Object uid, Timeline timeline) {
            this.uid = uid;
            this.timeline = timeline;
        }

        @Override
        public Object getUid() {
            return this.uid;
        }

        @Override
        public Timeline getTimeline() {
            return this.timeline;
        }
    }

    private static final class PlaybackInfoUpdate
    implements Runnable {
        private final PlaybackInfo playbackInfo;
        private final CopyOnWriteArrayList<BasePlayer.ListenerHolder> listenerSnapshot;
        private final TrackSelector trackSelector;
        private final boolean positionDiscontinuity;
        private final int positionDiscontinuityReason;
        private final int timelineChangeReason;
        private final boolean mediaItemTransitioned;
        private final int mediaItemTransitionReason;
        @Nullable
        private final MediaItem mediaItem;
        private final int playWhenReadyChangeReason;
        private final boolean seekProcessed;
        private final boolean playbackStateChanged;
        private final boolean playbackErrorChanged;
        private final boolean isLoadingChanged;
        private final boolean timelineChanged;
        private final boolean trackSelectorResultChanged;
        private final boolean playWhenReadyChanged;
        private final boolean playbackSuppressionReasonChanged;
        private final boolean isPlayingChanged;
        private final boolean playbackParametersChanged;
        private final boolean offloadSchedulingEnabledChanged;

        public PlaybackInfoUpdate(PlaybackInfo playbackInfo, PlaybackInfo previousPlaybackInfo, CopyOnWriteArrayList<BasePlayer.ListenerHolder> listeners, TrackSelector trackSelector, boolean positionDiscontinuity, int positionDiscontinuityReason, int timelineChangeReason, boolean mediaItemTransitioned, int mediaItemTransitionReason, @Nullable MediaItem mediaItem, int playWhenReadyChangeReason, boolean seekProcessed) {
            this.playbackInfo = playbackInfo;
            this.listenerSnapshot = new CopyOnWriteArrayList<BasePlayer.ListenerHolder>(listeners);
            this.trackSelector = trackSelector;
            this.positionDiscontinuity = positionDiscontinuity;
            this.positionDiscontinuityReason = positionDiscontinuityReason;
            this.timelineChangeReason = timelineChangeReason;
            this.mediaItemTransitioned = mediaItemTransitioned;
            this.mediaItemTransitionReason = mediaItemTransitionReason;
            this.mediaItem = mediaItem;
            this.playWhenReadyChangeReason = playWhenReadyChangeReason;
            this.seekProcessed = seekProcessed;
            this.playbackStateChanged = previousPlaybackInfo.playbackState != playbackInfo.playbackState;
            this.playbackErrorChanged = previousPlaybackInfo.playbackError != playbackInfo.playbackError && playbackInfo.playbackError != null;
            this.isLoadingChanged = previousPlaybackInfo.isLoading != playbackInfo.isLoading;
            this.timelineChanged = !previousPlaybackInfo.timeline.equals(playbackInfo.timeline);
            this.trackSelectorResultChanged = previousPlaybackInfo.trackSelectorResult != playbackInfo.trackSelectorResult;
            this.playWhenReadyChanged = previousPlaybackInfo.playWhenReady != playbackInfo.playWhenReady;
            this.playbackSuppressionReasonChanged = previousPlaybackInfo.playbackSuppressionReason != playbackInfo.playbackSuppressionReason;
            this.isPlayingChanged = PlaybackInfoUpdate.isPlaying(previousPlaybackInfo) != PlaybackInfoUpdate.isPlaying(playbackInfo);
            this.playbackParametersChanged = !previousPlaybackInfo.playbackParameters.equals(playbackInfo.playbackParameters);
            this.offloadSchedulingEnabledChanged = previousPlaybackInfo.offloadSchedulingEnabled != playbackInfo.offloadSchedulingEnabled;
        }

        @Override
        public void run() {
            if (this.timelineChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onTimelineChanged(this.playbackInfo.timeline, this.timelineChangeReason));
            }
            if (this.positionDiscontinuity) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPositionDiscontinuity(this.positionDiscontinuityReason));
            }
            if (this.mediaItemTransitioned) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onMediaItemTransition(this.mediaItem, this.mediaItemTransitionReason));
            }
            if (this.playbackErrorChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlayerError(this.playbackInfo.playbackError));
            }
            if (this.trackSelectorResultChanged) {
                this.trackSelector.onSelectionActivated(this.playbackInfo.trackSelectorResult.info);
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onTracksChanged(this.playbackInfo.trackGroups, this.playbackInfo.trackSelectorResult.selections));
            }
            if (this.isLoadingChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onIsLoadingChanged(this.playbackInfo.isLoading));
            }
            if (this.playbackStateChanged || this.playWhenReadyChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlayerStateChanged(this.playbackInfo.playWhenReady, this.playbackInfo.playbackState));
            }
            if (this.playbackStateChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlaybackStateChanged(this.playbackInfo.playbackState));
            }
            if (this.playWhenReadyChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlayWhenReadyChanged(this.playbackInfo.playWhenReady, this.playWhenReadyChangeReason));
            }
            if (this.playbackSuppressionReasonChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlaybackSuppressionReasonChanged(this.playbackInfo.playbackSuppressionReason));
            }
            if (this.isPlayingChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onIsPlayingChanged(PlaybackInfoUpdate.isPlaying(this.playbackInfo)));
            }
            if (this.playbackParametersChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlaybackParametersChanged(this.playbackInfo.playbackParameters));
            }
            if (this.seekProcessed) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, Player.EventListener::onSeekProcessed);
            }
            if (this.offloadSchedulingEnabledChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onExperimentalOffloadSchedulingEnabledChanged(this.playbackInfo.offloadSchedulingEnabled));
            }
        }

        private static boolean isPlaying(PlaybackInfo playbackInfo) {
            return playbackInfo.playbackState == 3 && playbackInfo.playWhenReady && playbackInfo.playbackSuppressionReason == 0;
        }
    }
}

