/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads;

import com.akamai.amp.ads.AdPosition;
import com.akamai.amp.utils.LogManager;

public abstract class AdsInfo {
    private static final String TAG = AdsInfo.class.getSimpleName();
    private static final String UNKNOWN_STRING = "-UNKNOWN-";
    public String adId = "-UNKNOWN-";
    public String name = "-UNKNOWN-";
    public int lengthInSeconds = 0;
    public double positionInStream = 1.0;
    public int adBreakTotal = 1;
    public int positionInAdBreak = 1;
    public AdPosition adPosition = AdPosition.PREROLL;
    public double adPodMaxDuration = -1.0;

    public String toString() {
        return this.getString(this.adId) + " " + this.getClass().getSimpleName() + " " + this.getString(this.lengthInSeconds) + "seconds, " + this.getString((Object)this.adPosition) + this.getString(this.positionInAdBreak) + "/ " + this.getString(this.adBreakTotal);
    }

    public boolean isPreroll() {
        boolean preroll = this.adPosition.isPreroll();
        LogManager.log(TAG, "isPreroll " + preroll);
        return preroll;
    }

    public boolean isMidroll() {
        boolean midroll = this.adPosition.isMidroll();
        LogManager.log(TAG, "isMidroll " + midroll);
        return midroll;
    }

    public boolean isPostroll() {
        boolean postroll = this.adPosition.isPostroll();
        LogManager.log(TAG, "isPostroll " + postroll);
        return postroll;
    }

    public boolean isFirstInAdBreak() {
        boolean result = 1 == this.positionInAdBreak;
        LogManager.log(TAG, "isFirstInAdBreak " + result);
        return result;
    }

    public boolean isLastInAdBreak() {
        boolean result = this.adBreakTotal == this.positionInAdBreak;
        LogManager.log(TAG, "isLastInAdBreak " + result);
        return result;
    }

    public boolean isLastPostroll() {
        boolean result = this.isPostroll() && this.isLastInAdBreak();
        LogManager.log(TAG, "isLastPostroll " + result);
        return result;
    }

    public String getPosition() {
        return this.adPosition.toString();
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString() + " ";
    }
}

