/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.poster;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;

public class Poster
extends LinearLayout {
    private ImageView posterContainer;

    public Poster(Context context) {
        super(context);
        this.setBackgroundColor(-16777216);
    }

    public void loadPoster(String source) {
        this.posterContainer = new ImageView(this.getContext());
        this.addView((View)this.posterContainer);
        new AsyncImageLoadeTask(this.posterContainer).execute(new String[]{source});
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.posterContainer.layout(l, t, r, b);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.posterContainer = null;
    }

    private class AsyncImageLoadeTask
    extends AsyncTask<String, Void, Bitmap> {
        private final WeakReference<ImageView> imageViewWeakReference;

        private AsyncImageLoadeTask(ImageView imageView) {
            this.imageViewWeakReference = new WeakReference<ImageView>(imageView);
        }

        protected Bitmap doInBackground(String ... params) {
            Bitmap bitmap = null;
            try {
                URL url = new URL(params[0]);
                bitmap = BitmapFactory.decodeStream((InputStream)url.openConnection().getInputStream());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return bitmap;
        }

        protected void onPostExecute(Bitmap bitmap) {
            ImageView imageView;
            if (this.imageViewWeakReference != null && bitmap != null && (imageView = (ImageView)this.imageViewWeakReference.get()) != null) {
                imageView.setImageBitmap(bitmap);
            }
        }
    }
}

