/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.utils;

import android.util.Log;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UtilsParser {
    private static final String TAG = "RootParser";
    private static final int spacesToIndentEachLevel = 2;

    public static String prettyPrint(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            String str = jsonObject.toString(2);
            return str;
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return json;
        }
    }

    public static String mapToJson(Map<String, String> values) {
        if (values == null) {
            return "";
        }
        JSONObject jsonObject = new JSONObject(values);
        if (jsonObject == null) {
            return "";
        }
        return jsonObject.toString();
    }

    public static String getValue(String value, JSONObject from) {
        if (value == null || from == null) {
            return null;
        }
        try {
            String result = from.getString(value);
            return result;
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return null;
        }
    }

    public static JSONObject getObjectFromArray(int position, JSONArray from) {
        if (position < 0) {
            return null;
        }
        try {
            return from.getJSONObject(position);
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return null;
        }
    }

    public static boolean existObj(String newObj, JSONObject from) {
        if (newObj == null || from == null) {
            return false;
        }
        return from.has(newObj);
    }

    public static JSONObject getObj(String newObj, JSONObject from) {
        if (newObj == null || from == null) {
            return null;
        }
        try {
            JSONObject result = from.getJSONObject(newObj);
            return result;
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return null;
        }
    }

    public static JSONArray getJsonArray(String newObj, JSONObject from) {
        if (newObj == null || from == null) {
            return null;
        }
        try {
            JSONArray result = from.getJSONArray(newObj);
            return result;
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return null;
        }
    }

    public static JSONObject getJsonObjectFromArray(JSONArray array, int i) {
        try {
            JSONObject jsonObject = array.getJSONObject(i);
            return jsonObject;
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return null;
        }
    }

    public static String getString(String key, JSONObject jsonObject) {
        try {
            String result = jsonObject.getString(key);
            return result;
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return "";
        }
    }

    public static JSONObject getObjectFromString(String content) {
        try {
            return new JSONObject(content);
        }
        catch (JSONException e) {
            UtilsParser.report((Exception)((Object)e));
            return null;
        }
    }

    private static void report(Exception e) {
        Log.d((String)TAG, (String)(e == null ? "ERROR" : e.toString()));
    }
}

