/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.errors;

import java.util.HashMap;
import java.util.Map;

public enum ErrorType {
    TYPE_SOURCE,
    TYPE_RENDERER,
    TYPE_UNEXPECTED,
    VIDEO_PLAYER_CONTAINER_ERROR,
    UNKNOWN,
    MAX_CONNECTION_ATTEMPTS_REACHED;

    private static final Map<Integer, ErrorType> OLD_TO_NEW_EVENTS;

    public static ErrorType fromPlayerCode(int lastErrorCode) {
        boolean exists = OLD_TO_NEW_EVENTS.containsKey(lastErrorCode -= 7);
        if (exists) {
            ErrorType errorType = OLD_TO_NEW_EVENTS.get(lastErrorCode);
            return errorType;
        }
        return UNKNOWN;
    }

    static {
        OLD_TO_NEW_EVENTS = new HashMap<Integer, ErrorType>(){
            {
                this.put(0, TYPE_SOURCE);
                this.put(1, TYPE_RENDERER);
                this.put(2, TYPE_UNEXPECTED);
            }
        };
    }
}

