/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.decryption;

import com.akamai.amp.license.decryption.InvalidDataException;
import com.akamai.amp.license.decryption.Validate;
import java.util.Arrays;

abstract class AES256Ciphertext {
    static final int FLAG_PASSWORD = 1;
    static final int ENCRYPTION_SALT_LENGTH = 8;
    static final int HMAC_SALT_LENGTH = 8;
    static final int AES_BLOCK_SIZE = 16;
    static final int HMAC_SIZE = 32;
    static final int HEADER_SIZE = 2;
    static final int MINIMUM_LENGTH_WITH_PASSWORD = 66;
    static final int MINIMUM_LENGTH_WITHOUT_PASSWORD = 50;
    private final int version;
    private final byte options;
    private final byte[] encryptionSalt;
    private final byte[] hmacSalt;
    private final byte[] iv;
    private final byte[] ciphertext;
    private byte[] hmac;
    private final boolean isPasswordBased;

    AES256Ciphertext(byte[] data) throws InvalidDataException {
        int minimumLength;
        Validate.notNull(data, "Data cannot be null.", new Object[0]);
        if (data.length < 2) {
            throw new InvalidDataException("Not enough data to read header.");
        }
        int index = 0;
        this.version = data[index++];
        if (this.version != this.getVersionNumber()) {
            throw new InvalidDataException(String.format("Expected version %d but found %d.", this.getVersionNumber(), this.version));
        }
        this.options = data[index++];
        if (this.options != 0 && this.options != 1) {
            throw new InvalidDataException("Unrecognised bit in the options byte.");
        }
        this.isPasswordBased = (this.options & 1) == 1;
        int n = minimumLength = this.isPasswordBased ? 66 : 50;
        if (data.length < minimumLength) {
            throw new InvalidDataException(String.format("Data must be a minimum length of %d bytes, but found %d bytes.", minimumLength, data.length));
        }
        int ciphertextLength = data.length - minimumLength;
        if (this.isPasswordBased) {
            this.encryptionSalt = new byte[8];
            System.arraycopy(data, index, this.encryptionSalt, 0, this.encryptionSalt.length);
            this.hmacSalt = new byte[8];
            System.arraycopy(data, index += this.encryptionSalt.length, this.hmacSalt, 0, this.hmacSalt.length);
            index += this.hmacSalt.length;
        } else {
            this.encryptionSalt = null;
            this.hmacSalt = null;
        }
        this.iv = new byte[16];
        System.arraycopy(data, index, this.iv, 0, this.iv.length);
        this.ciphertext = new byte[ciphertextLength];
        System.arraycopy(data, index += this.iv.length, this.ciphertext, 0, ciphertextLength);
        this.hmac = new byte[32];
        System.arraycopy(data, index += ciphertextLength, this.hmac, 0, this.hmac.length);
    }

    AES256Ciphertext(byte[] encryptionSalt, byte[] hmacSalt, byte[] iv, byte[] ciphertext) {
        AES256Ciphertext.validateLength(encryptionSalt, "encryption salt", 8);
        AES256Ciphertext.validateLength(hmacSalt, "HMAC salt", 8);
        AES256Ciphertext.validateLength(iv, "IV", 16);
        this.version = this.getVersionNumber();
        this.options = 1;
        this.encryptionSalt = encryptionSalt;
        this.hmacSalt = hmacSalt;
        this.iv = iv;
        this.ciphertext = ciphertext;
        this.isPasswordBased = true;
        this.hmac = new byte[32];
    }

    AES256Ciphertext(byte[] iv, byte[] ciphertext) {
        AES256Ciphertext.validateLength(iv, "IV", 16);
        this.version = this.getVersionNumber();
        this.options = 0;
        this.iv = iv;
        this.ciphertext = ciphertext;
        this.encryptionSalt = null;
        this.hmacSalt = null;
        this.isPasswordBased = false;
        this.hmac = new byte[32];
    }

    private static void validateLength(byte[] data, String dataName, int expectedLength) throws IllegalArgumentException {
        if (data.length != expectedLength) {
            throw new IllegalArgumentException(String.format("Invalid %s length. Expected %d bytes but found %d.", dataName, expectedLength, data.length));
        }
    }

    byte[] getRawData() {
        byte[] header = new byte[]{(byte)this.getVersionNumber(), 0};
        if (this.isPasswordBased) {
            header[1] = (byte)(header[1] | 1);
        }
        int dataSize = this.isPasswordBased ? header.length + this.encryptionSalt.length + this.hmacSalt.length + this.iv.length + this.ciphertext.length + this.hmac.length : header.length + this.iv.length + this.ciphertext.length + this.hmac.length;
        byte[] result = new byte[dataSize];
        System.arraycopy(header, 0, result, 0, header.length);
        if (this.isPasswordBased) {
            System.arraycopy(this.encryptionSalt, 0, result, header.length, this.encryptionSalt.length);
            System.arraycopy(this.hmacSalt, 0, result, header.length + this.encryptionSalt.length, this.hmacSalt.length);
            System.arraycopy(this.iv, 0, result, header.length + this.encryptionSalt.length + this.hmacSalt.length, this.iv.length);
            System.arraycopy(this.ciphertext, 0, result, header.length + this.encryptionSalt.length + this.hmacSalt.length + this.iv.length, this.ciphertext.length);
            System.arraycopy(this.hmac, 0, result, header.length + this.encryptionSalt.length + this.hmacSalt.length + this.iv.length + this.ciphertext.length, this.hmac.length);
        } else {
            System.arraycopy(this.iv, 0, result, header.length, this.iv.length);
            System.arraycopy(this.ciphertext, 0, result, header.length + this.iv.length, this.ciphertext.length);
            System.arraycopy(this.hmac, 0, result, header.length + this.iv.length + this.ciphertext.length, this.hmac.length);
        }
        return result;
    }

    byte[] getDataToHMAC() {
        byte[] rawData = this.getRawData();
        byte[] result = new byte[rawData.length - 32];
        System.arraycopy(rawData, 0, result, 0, result.length);
        return result;
    }

    int getVersion() {
        return this.version;
    }

    byte getOptions() {
        return this.options;
    }

    byte[] getEncryptionSalt() {
        return this.encryptionSalt;
    }

    byte[] getHmacSalt() {
        return this.hmacSalt;
    }

    byte[] getIv() {
        return this.iv;
    }

    byte[] getCiphertext() {
        return this.ciphertext;
    }

    byte[] getHmac() {
        return this.hmac;
    }

    public boolean isPasswordBased() {
        return this.isPasswordBased;
    }

    void setHmac(byte[] hmac) {
        this.hmac = hmac;
    }

    abstract int getVersionNumber();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.ciphertext);
        result = 31 * result + Arrays.hashCode(this.encryptionSalt);
        result = 31 * result + Arrays.hashCode(this.hmac);
        result = 31 * result + Arrays.hashCode(this.hmacSalt);
        result = 31 * result + (this.isPasswordBased ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.iv);
        result = 31 * result + this.options;
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AES256Ciphertext other = (AES256Ciphertext)obj;
        if (!Arrays.equals(this.ciphertext, other.ciphertext)) {
            return false;
        }
        if (!Arrays.equals(this.encryptionSalt, other.encryptionSalt)) {
            return false;
        }
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        if (!Arrays.equals(this.hmacSalt, other.hmacSalt)) {
            return false;
        }
        if (this.isPasswordBased != other.isPasswordBased) {
            return false;
        }
        if (!Arrays.equals(this.iv, other.iv)) {
            return false;
        }
        if (this.options != other.options) {
            return false;
        }
        return this.version == other.version;
    }
}

