/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectorResult;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;

public abstract class TrackSelector {
    @Nullable
    private InvalidationListener listener;
    @Nullable
    private BandwidthMeter bandwidthMeter;

    public final void init(InvalidationListener listener, BandwidthMeter bandwidthMeter) {
        this.listener = listener;
        this.bandwidthMeter = bandwidthMeter;
    }

    public abstract TrackSelectorResult selectTracks(RendererCapabilities[] var1, TrackGroupArray var2, MediaSource.MediaPeriodId var3, Timeline var4) throws ExoPlaybackException;

    public abstract void onSelectionActivated(@Nullable Object var1);

    protected final void invalidate() {
        if (this.listener != null) {
            this.listener.onTrackSelectionsInvalidated();
        }
    }

    protected final BandwidthMeter getBandwidthMeter() {
        return Assertions.checkNotNull(this.bandwidthMeter);
    }

    public static interface InvalidationListener {
        public void onTrackSelectionsInvalidated();
    }
}

