/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.drm.DrmInitData;
import com.akamai.amp.exoplayer2.extractor.DefaultExtractorInput;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.id3.Id3Decoder;
import com.akamai.amp.exoplayer2.metadata.id3.PrivFrame;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.hls.Aes128DataSource;
import com.akamai.amp.exoplayer2.source.hls.HlsExtractorFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsMediaChunkExtractor;
import com.akamai.amp.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.akamai.amp.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.util.TimestampAdjuster;
import com.akamai.amp.exoplayer2.util.UriUtil;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class HlsMediaChunk
extends MediaChunk {
    public static final String PRIV_TIMESTAMP_FRAME_OWNER = "com.apple.streaming.transportStreamTimestamp";
    private static final AtomicInteger uidSource = new AtomicInteger();
    public final int uid;
    public final int discontinuitySequenceNumber;
    public final Uri playlistUrl;
    public final boolean shouldSpliceIn;
    @Nullable
    private final DataSource initDataSource;
    @Nullable
    private final DataSpec initDataSpec;
    @Nullable
    private final HlsMediaChunkExtractor previousExtractor;
    private final boolean isMasterTimestampSource;
    private final boolean hasGapTag;
    private final TimestampAdjuster timestampAdjuster;
    private final HlsExtractorFactory extractorFactory;
    @Nullable
    private final List<Format> muxedCaptionFormats;
    @Nullable
    private final DrmInitData drmInitData;
    private final Id3Decoder id3Decoder;
    private final ParsableByteArray scratchId3Data;
    private final boolean mediaSegmentEncrypted;
    private final boolean initSegmentEncrypted;
    private @MonotonicNonNull HlsMediaChunkExtractor extractor;
    private @MonotonicNonNull HlsSampleStreamWrapper output;
    private int nextLoadPosition;
    private boolean initDataLoadRequired;
    private volatile boolean loadCanceled;
    private boolean loadCompleted;
    private ImmutableList<Integer> sampleQueueFirstSampleIndices;
    private boolean extractorInvalidated;

    public static HlsMediaChunk createInstance(HlsExtractorFactory extractorFactory, DataSource dataSource, Format format, long startOfPlaylistInPeriodUs, HlsMediaPlaylist mediaPlaylist, int segmentIndexInPlaylist, Uri playlistUrl, @Nullable List<Format> muxedCaptionFormats, int trackSelectionReason, @Nullable Object trackSelectionData, boolean isMasterTimestampSource, TimestampAdjusterProvider timestampAdjusterProvider, @Nullable HlsMediaChunk previousChunk, @Nullable byte[] mediaSegmentKey, @Nullable byte[] initSegmentKey) {
        boolean shouldSpliceIn;
        ParsableByteArray scratchId3Data;
        Id3Decoder id3Decoder;
        HlsMediaPlaylist.Segment mediaSegment = mediaPlaylist.segments.get(segmentIndexInPlaylist);
        DataSpec dataSpec = new DataSpec(UriUtil.resolveToUri(mediaPlaylist.baseUri, mediaSegment.url), mediaSegment.byteRangeOffset, mediaSegment.byteRangeLength);
        boolean mediaSegmentEncrypted = mediaSegmentKey != null;
        byte[] mediaSegmentIv = mediaSegmentEncrypted ? HlsMediaChunk.getEncryptionIvArray(Assertions.checkNotNull(mediaSegment.encryptionIV)) : null;
        DataSource mediaDataSource = HlsMediaChunk.buildDataSource(dataSource, mediaSegmentKey, mediaSegmentIv);
        HlsMediaPlaylist.Segment initSegment = mediaSegment.initializationSegment;
        DataSpec initDataSpec = null;
        boolean initSegmentEncrypted = false;
        DataSource initDataSource = null;
        if (initSegment != null) {
            initSegmentEncrypted = initSegmentKey != null;
            byte[] initSegmentIv = initSegmentEncrypted ? HlsMediaChunk.getEncryptionIvArray(Assertions.checkNotNull(initSegment.encryptionIV)) : null;
            Uri initSegmentUri = UriUtil.resolveToUri(mediaPlaylist.baseUri, initSegment.url);
            initDataSpec = new DataSpec(initSegmentUri, initSegment.byteRangeOffset, initSegment.byteRangeLength);
            initDataSource = HlsMediaChunk.buildDataSource(dataSource, initSegmentKey, initSegmentIv);
        }
        long segmentStartTimeInPeriodUs = startOfPlaylistInPeriodUs + mediaSegment.relativeStartTimeUs;
        long segmentEndTimeInPeriodUs = segmentStartTimeInPeriodUs + mediaSegment.durationUs;
        int discontinuitySequenceNumber = mediaPlaylist.discontinuitySequence + mediaSegment.relativeDiscontinuitySequence;
        HlsMediaChunkExtractor previousExtractor = null;
        if (previousChunk != null) {
            boolean isFollowingChunk = playlistUrl.equals((Object)previousChunk.playlistUrl) && previousChunk.loadCompleted;
            id3Decoder = previousChunk.id3Decoder;
            scratchId3Data = previousChunk.scratchId3Data;
            boolean canContinueWithoutSplice = isFollowingChunk || mediaPlaylist.hasIndependentSegments && segmentStartTimeInPeriodUs >= previousChunk.endTimeUs;
            shouldSpliceIn = !canContinueWithoutSplice;
            previousExtractor = isFollowingChunk && !previousChunk.extractorInvalidated && previousChunk.discontinuitySequenceNumber == discontinuitySequenceNumber ? previousChunk.extractor : null;
        } else {
            id3Decoder = new Id3Decoder();
            scratchId3Data = new ParsableByteArray(10);
            shouldSpliceIn = false;
        }
        return new HlsMediaChunk(extractorFactory, mediaDataSource, dataSpec, format, mediaSegmentEncrypted, initDataSource, initDataSpec, initSegmentEncrypted, playlistUrl, muxedCaptionFormats, trackSelectionReason, trackSelectionData, segmentStartTimeInPeriodUs, segmentEndTimeInPeriodUs, mediaPlaylist.mediaSequence + (long)segmentIndexInPlaylist, discontinuitySequenceNumber, mediaSegment.hasGapTag, isMasterTimestampSource, timestampAdjusterProvider.getAdjuster(discontinuitySequenceNumber), mediaSegment.drmInitData, previousExtractor, id3Decoder, scratchId3Data, shouldSpliceIn);
    }

    private HlsMediaChunk(HlsExtractorFactory extractorFactory, DataSource mediaDataSource, DataSpec dataSpec, Format format, boolean mediaSegmentEncrypted, @Nullable DataSource initDataSource, @Nullable DataSpec initDataSpec, boolean initSegmentEncrypted, Uri playlistUrl, @Nullable List<Format> muxedCaptionFormats, int trackSelectionReason, @Nullable Object trackSelectionData, long startTimeUs, long endTimeUs, long chunkMediaSequence, int discontinuitySequenceNumber, boolean hasGapTag, boolean isMasterTimestampSource, TimestampAdjuster timestampAdjuster, @Nullable DrmInitData drmInitData, @Nullable HlsMediaChunkExtractor previousExtractor, Id3Decoder id3Decoder, ParsableByteArray scratchId3Data, boolean shouldSpliceIn) {
        super(mediaDataSource, dataSpec, format, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkMediaSequence);
        this.mediaSegmentEncrypted = mediaSegmentEncrypted;
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.initDataSpec = initDataSpec;
        this.initDataSource = initDataSource;
        this.initDataLoadRequired = initDataSpec != null;
        this.initSegmentEncrypted = initSegmentEncrypted;
        this.playlistUrl = playlistUrl;
        this.isMasterTimestampSource = isMasterTimestampSource;
        this.timestampAdjuster = timestampAdjuster;
        this.hasGapTag = hasGapTag;
        this.extractorFactory = extractorFactory;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.drmInitData = drmInitData;
        this.previousExtractor = previousExtractor;
        this.id3Decoder = id3Decoder;
        this.scratchId3Data = scratchId3Data;
        this.shouldSpliceIn = shouldSpliceIn;
        this.sampleQueueFirstSampleIndices = ImmutableList.of();
        this.uid = uidSource.getAndIncrement();
    }

    public void init(HlsSampleStreamWrapper output, ImmutableList<Integer> sampleQueueWriteIndices) {
        this.output = output;
        this.sampleQueueFirstSampleIndices = sampleQueueWriteIndices;
    }

    public int getFirstSampleIndex(int sampleQueueIndex) {
        Assertions.checkState(!this.shouldSpliceIn);
        if (sampleQueueIndex >= this.sampleQueueFirstSampleIndices.size()) {
            return 0;
        }
        return (Integer)this.sampleQueueFirstSampleIndices.get(sampleQueueIndex);
    }

    public void invalidateExtractor() {
        this.extractorInvalidated = true;
    }

    @Override
    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public void load() throws IOException {
        Assertions.checkNotNull(this.output);
        if (this.extractor == null && this.previousExtractor != null && this.previousExtractor.isReusable()) {
            this.extractor = this.previousExtractor;
            this.initDataLoadRequired = false;
        }
        this.maybeLoadInitData();
        if (!this.loadCanceled) {
            if (!this.hasGapTag) {
                this.loadMedia();
            }
            this.loadCompleted = !this.loadCanceled;
        }
    }

    @RequiresNonNull(value={"output"})
    private void maybeLoadInitData() throws IOException {
        if (!this.initDataLoadRequired) {
            return;
        }
        Assertions.checkNotNull(this.initDataSource);
        Assertions.checkNotNull(this.initDataSpec);
        this.feedDataToExtractor(this.initDataSource, this.initDataSpec, this.initSegmentEncrypted);
        this.nextLoadPosition = 0;
        this.initDataLoadRequired = false;
    }

    @RequiresNonNull(value={"output"})
    private void loadMedia() throws IOException {
        if (!this.isMasterTimestampSource) {
            try {
                this.timestampAdjuster.waitUntilInitialized();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        } else if (this.timestampAdjuster.getFirstSampleTimestampUs() == Long.MAX_VALUE) {
            this.timestampAdjuster.setFirstSampleTimestampUs(this.startTimeUs);
        }
        this.feedDataToExtractor(this.dataSource, this.dataSpec, this.mediaSegmentEncrypted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNonNull(value={"output"})
    private void feedDataToExtractor(DataSource dataSource, DataSpec dataSpec, boolean dataIsEncrypted) throws IOException {
        block13: {
            boolean skipLoadedBytes;
            DataSpec loadDataSpec;
            if (dataIsEncrypted) {
                loadDataSpec = dataSpec;
                skipLoadedBytes = this.nextLoadPosition != 0;
            } else {
                loadDataSpec = dataSpec.subrange(this.nextLoadPosition);
                skipLoadedBytes = false;
            }
            try {
                DefaultExtractorInput input = this.prepareExtraction(dataSource, loadDataSpec);
                if (skipLoadedBytes) {
                    input.skipFully(this.nextLoadPosition);
                }
                try {
                    while (!this.loadCanceled && this.extractor.read(input)) {
                    }
                }
                catch (EOFException e) {
                    if ((this.trackFormat.roleFlags & 0x4000) != 0) {
                        this.extractor.onTruncatedSegmentParsed();
                        break block13;
                    }
                    throw e;
                }
                finally {
                    this.nextLoadPosition = (int)(input.getPosition() - dataSpec.position);
                }
            }
            finally {
                Util.closeQuietly(dataSource);
            }
        }
    }

    @RequiresNonNull(value={"output"})
    @EnsuresNonNull(value={"extractor"})
    private DefaultExtractorInput prepareExtraction(DataSource dataSource, DataSpec dataSpec) throws IOException {
        long bytesToRead = dataSource.open(dataSpec);
        DefaultExtractorInput extractorInput = new DefaultExtractorInput(dataSource, dataSpec.position, bytesToRead);
        if (this.extractor == null) {
            long id3Timestamp = this.peekId3PrivTimestamp(extractorInput);
            extractorInput.resetPeekPosition();
            HlsMediaChunkExtractor hlsMediaChunkExtractor = this.extractor = this.previousExtractor != null ? this.previousExtractor.recreate() : this.extractorFactory.createExtractor(dataSpec.uri, this.trackFormat, this.muxedCaptionFormats, this.timestampAdjuster, dataSource.getResponseHeaders(), extractorInput);
            if (this.extractor.isPackedAudioExtractor()) {
                this.output.setSampleOffsetUs(id3Timestamp != -9223372036854775807L ? this.timestampAdjuster.adjustTsTimestamp(id3Timestamp) : this.startTimeUs);
            } else {
                this.output.setSampleOffsetUs(0L);
            }
            this.output.onNewExtractor();
            this.extractor.init(this.output);
        }
        this.output.setDrmInitData(this.drmInitData);
        return extractorInput;
    }

    private long peekId3PrivTimestamp(ExtractorInput input) throws IOException {
        input.resetPeekPosition();
        try {
            input.peekFully(this.scratchId3Data.getData(), 0, 10);
        }
        catch (EOFException e) {
            return -9223372036854775807L;
        }
        this.scratchId3Data.reset(10);
        int id = this.scratchId3Data.readUnsignedInt24();
        if (id != 0x494433) {
            return -9223372036854775807L;
        }
        this.scratchId3Data.skipBytes(3);
        int id3Size = this.scratchId3Data.readSynchSafeInt();
        int requiredCapacity = id3Size + 10;
        if (requiredCapacity > this.scratchId3Data.capacity()) {
            byte[] data = this.scratchId3Data.getData();
            this.scratchId3Data.reset(requiredCapacity);
            System.arraycopy(data, 0, this.scratchId3Data.getData(), 0, 10);
        }
        input.peekFully(this.scratchId3Data.getData(), 10, id3Size);
        Metadata metadata = this.id3Decoder.decode(this.scratchId3Data.getData(), id3Size);
        if (metadata == null) {
            return -9223372036854775807L;
        }
        int metadataLength = metadata.length();
        for (int i = 0; i < metadataLength; ++i) {
            Metadata.Entry frame = metadata.get(i);
            if (!(frame instanceof PrivFrame)) continue;
            PrivFrame privFrame = (PrivFrame)frame;
            if (!PRIV_TIMESTAMP_FRAME_OWNER.equals(privFrame.owner)) continue;
            System.arraycopy(privFrame.privateData, 0, this.scratchId3Data.getData(), 0, 8);
            this.scratchId3Data.reset(8);
            return this.scratchId3Data.readLong() & 0x1FFFFFFFFL;
        }
        return -9223372036854775807L;
    }

    private static byte[] getEncryptionIvArray(String ivString) {
        String trimmedIv = Util.toLowerInvariant(ivString).startsWith("0x") ? ivString.substring(2) : ivString;
        byte[] ivData = new BigInteger(trimmedIv, 16).toByteArray();
        byte[] ivDataWithPadding = new byte[16];
        int offset = ivData.length > 16 ? ivData.length - 16 : 0;
        System.arraycopy(ivData, offset, ivDataWithPadding, ivDataWithPadding.length - ivData.length + offset, ivData.length - offset);
        return ivDataWithPadding;
    }

    private static DataSource buildDataSource(DataSource dataSource, @Nullable byte[] fullSegmentEncryptionKey, @Nullable byte[] encryptionIv) {
        if (fullSegmentEncryptionKey != null) {
            Assertions.checkNotNull(encryptionIv);
            return new Aes128DataSource(dataSource, fullSegmentEncryptionKey, encryptionIv);
        }
        return dataSource;
    }
}

