/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.offline.Downloader;
import com.akamai.amp.exoplayer2.offline.FilterableManifest;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.ParsingLoadable;
import com.akamai.amp.exoplayer2.upstream.cache.Cache;
import com.akamai.amp.exoplayer2.upstream.cache.CacheDataSource;
import com.akamai.amp.exoplayer2.upstream.cache.CacheKeyFactory;
import com.akamai.amp.exoplayer2.upstream.cache.CacheWriter;
import com.akamai.amp.exoplayer2.upstream.cache.ContentMetadata;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.PriorityTaskManager;
import com.akamai.amp.exoplayer2.util.RunnableFutureTask;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public abstract class SegmentDownloader<M extends FilterableManifest<M>>
implements Downloader {
    private static final int BUFFER_SIZE_BYTES = 131072;
    private static final long MAX_MERGED_SEGMENT_START_TIME_DIFF_US = 20000000L;
    private final DataSpec manifestDataSpec;
    private final ParsingLoadable.Parser<M> manifestParser;
    private final ArrayList<StreamKey> streamKeys;
    private final CacheDataSource.Factory cacheDataSourceFactory;
    private final Cache cache;
    private final CacheKeyFactory cacheKeyFactory;
    @Nullable
    private final PriorityTaskManager priorityTaskManager;
    private final Executor executor;
    private final ArrayList<RunnableFutureTask<?, ?>> activeRunnables;
    private volatile boolean isCanceled;

    public SegmentDownloader(MediaItem mediaItem, ParsingLoadable.Parser<M> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        Assertions.checkNotNull(mediaItem.playbackProperties);
        this.manifestDataSpec = SegmentDownloader.getCompressibleDataSpec(mediaItem.playbackProperties.uri);
        this.manifestParser = manifestParser;
        this.streamKeys = new ArrayList<StreamKey>(mediaItem.playbackProperties.streamKeys);
        this.cacheDataSourceFactory = cacheDataSourceFactory;
        this.executor = executor;
        this.cache = Assertions.checkNotNull(cacheDataSourceFactory.getCache());
        this.cacheKeyFactory = cacheDataSourceFactory.getCacheKeyFactory();
        this.priorityTaskManager = cacheDataSourceFactory.getUpstreamPriorityTaskManager();
        this.activeRunnables = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void download(@Nullable Downloader.ProgressListener progressListener) throws IOException, InterruptedException {
        ArrayDeque<Segment> pendingSegments = new ArrayDeque<Segment>();
        ArrayDeque<SegmentDownloadRunnable> recycledRunnables = new ArrayDeque<SegmentDownloadRunnable>();
        if (this.priorityTaskManager != null) {
            this.priorityTaskManager.add(-1000);
        }
        try {
            CacheDataSource dataSource = this.cacheDataSourceFactory.createDataSourceForDownloading();
            Object manifest = this.getManifest(dataSource, this.manifestDataSpec, false);
            if (!this.streamKeys.isEmpty()) {
                manifest = (FilterableManifest)manifest.copy(this.streamKeys);
            }
            List<Segment> segments = this.getSegments(dataSource, manifest, false);
            Collections.sort(segments);
            SegmentDownloader.mergeSegments(segments, this.cacheKeyFactory);
            int totalSegments = segments.size();
            int segmentsDownloaded = 0;
            long contentLength = 0L;
            long bytesDownloaded = 0L;
            for (int i = segments.size() - 1; i >= 0; --i) {
                long resourceLength;
                DataSpec dataSpec = segments.get((int)i).dataSpec;
                String cacheKey = this.cacheKeyFactory.buildCacheKey(dataSpec);
                long segmentLength = dataSpec.length;
                if (segmentLength == -1L && (resourceLength = ContentMetadata.getContentLength(this.cache.getContentMetadata(cacheKey))) != -1L) {
                    segmentLength = resourceLength - dataSpec.position;
                }
                long segmentBytesDownloaded = this.cache.getCachedBytes(cacheKey, dataSpec.position, segmentLength);
                bytesDownloaded += segmentBytesDownloaded;
                if (segmentLength != -1L) {
                    if (segmentLength == segmentBytesDownloaded) {
                        ++segmentsDownloaded;
                        segments.remove(i);
                    }
                    if (contentLength == -1L) continue;
                    contentLength += segmentLength;
                    continue;
                }
                contentLength = -1L;
            }
            ProgressNotifier progressNotifier = progressListener != null ? new ProgressNotifier(progressListener, contentLength, totalSegments, bytesDownloaded, segmentsDownloaded) : null;
            pendingSegments.addAll(segments);
            while (!this.isCanceled && !pendingSegments.isEmpty()) {
                byte[] temporaryBuffer;
                CacheDataSource segmentDataSource;
                if (this.priorityTaskManager != null) {
                    this.priorityTaskManager.proceed(-1000);
                }
                if (!recycledRunnables.isEmpty()) {
                    SegmentDownloadRunnable recycledRunnable = (SegmentDownloadRunnable)recycledRunnables.removeFirst();
                    segmentDataSource = recycledRunnable.dataSource;
                    temporaryBuffer = recycledRunnable.temporaryBuffer;
                } else {
                    segmentDataSource = this.cacheDataSourceFactory.createDataSourceForDownloading();
                    temporaryBuffer = new byte[131072];
                }
                Segment segment = (Segment)pendingSegments.removeFirst();
                SegmentDownloadRunnable downloadRunnable = new SegmentDownloadRunnable(segment, segmentDataSource, progressNotifier, temporaryBuffer);
                this.addActiveRunnable(downloadRunnable);
                this.executor.execute(downloadRunnable);
                for (int j = this.activeRunnables.size() - 1; j >= 0; --j) {
                    SegmentDownloadRunnable activeRunnable = (SegmentDownloadRunnable)this.activeRunnables.get(j);
                    if (!pendingSegments.isEmpty() && !activeRunnable.isDone()) continue;
                    try {
                        activeRunnable.get();
                        this.removeActiveRunnable(j);
                        recycledRunnables.addLast(activeRunnable);
                        continue;
                    }
                    catch (ExecutionException e) {
                        Throwable cause = Assertions.checkNotNull(e.getCause());
                        if (cause instanceof PriorityTaskManager.PriorityTooLowException) {
                            pendingSegments.addFirst(activeRunnable.segment);
                            this.removeActiveRunnable(j);
                            recycledRunnables.addLast(activeRunnable);
                            continue;
                        }
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        Util.sneakyThrow(cause);
                    }
                }
                downloadRunnable.blockUntilStarted();
            }
        }
        finally {
            int i;
            for (i = 0; i < this.activeRunnables.size(); ++i) {
                this.activeRunnables.get(i).cancel(true);
            }
            for (i = this.activeRunnables.size() - 1; i >= 0; --i) {
                this.activeRunnables.get(i).blockUntilFinished();
                this.removeActiveRunnable(i);
            }
            if (this.priorityTaskManager != null) {
                this.priorityTaskManager.remove(-1000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ArrayList<RunnableFutureTask<?, ?>> arrayList = this.activeRunnables;
        synchronized (arrayList) {
            this.isCanceled = true;
            for (int i = 0; i < this.activeRunnables.size(); ++i) {
                this.activeRunnables.get(i).cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove() {
        CacheDataSource dataSource = this.cacheDataSourceFactory.createDataSourceForRemovingDownload();
        try {
            M manifest = this.getManifest(dataSource, this.manifestDataSpec, true);
            List<Segment> segments = this.getSegments(dataSource, manifest, true);
            for (int i = 0; i < segments.size(); ++i) {
                this.cache.removeResource(this.cacheKeyFactory.buildCacheKey(segments.get((int)i).dataSpec));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this.cache.removeResource(this.cacheKeyFactory.buildCacheKey(this.manifestDataSpec));
        }
    }

    protected final M getManifest(final DataSource dataSource, final DataSpec dataSpec, boolean removing) throws InterruptedException, IOException {
        return (M)((FilterableManifest)this.execute(new RunnableFutureTask<M, IOException>(){

            @Override
            protected M doWork() throws IOException {
                return (FilterableManifest)ParsingLoadable.load(dataSource, SegmentDownloader.this.manifestParser, dataSpec, 4);
            }
        }, removing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T execute(RunnableFutureTask<T, ?> runnable, boolean removing) throws InterruptedException, IOException {
        Throwable cause;
        if (removing) {
            runnable.run();
            try {
                return runnable.get();
            }
            catch (ExecutionException e) {
                cause = Assertions.checkNotNull(e.getCause());
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                Util.sneakyThrow(e);
            }
        }
        while (true) {
            if (this.isCanceled) {
                throw new InterruptedException();
            }
            if (this.priorityTaskManager != null) {
                this.priorityTaskManager.proceed(-1000);
            }
            this.addActiveRunnable(runnable);
            this.executor.execute(runnable);
            try {
                T e = runnable.get();
                return e;
            }
            catch (ExecutionException e) {
                cause = Assertions.checkNotNull(e.getCause());
                if (cause instanceof PriorityTaskManager.PriorityTooLowException) continue;
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                Util.sneakyThrow(e);
                continue;
            }
            finally {
                runnable.blockUntilFinished();
                this.removeActiveRunnable(runnable);
                continue;
            }
            break;
        }
    }

    protected abstract List<Segment> getSegments(DataSource var1, M var2, boolean var3) throws IOException, InterruptedException;

    protected static DataSpec getCompressibleDataSpec(Uri uri) {
        return new DataSpec.Builder().setUri(uri).setFlags(1).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addActiveRunnable(RunnableFutureTask<T, ?> runnable) throws InterruptedException {
        ArrayList<RunnableFutureTask<?, ?>> arrayList = this.activeRunnables;
        synchronized (arrayList) {
            if (this.isCanceled) {
                throw new InterruptedException();
            }
            this.activeRunnables.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActiveRunnable(RunnableFutureTask<?, ?> runnable) {
        ArrayList<RunnableFutureTask<?, ?>> arrayList = this.activeRunnables;
        synchronized (arrayList) {
            this.activeRunnables.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActiveRunnable(int index) {
        ArrayList<RunnableFutureTask<?, ?>> arrayList = this.activeRunnables;
        synchronized (arrayList) {
            this.activeRunnables.remove(index);
        }
    }

    private static void mergeSegments(List<Segment> segments, CacheKeyFactory keyFactory) {
        HashMap<String, Integer> lastIndexByCacheKey = new HashMap<String, Integer>();
        int nextOutIndex = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment lastSegment;
            Segment segment = segments.get(i);
            String cacheKey = keyFactory.buildCacheKey(segment.dataSpec);
            Integer lastIndex = (Integer)lastIndexByCacheKey.get(cacheKey);
            Segment segment2 = lastSegment = lastIndex == null ? null : segments.get(lastIndex);
            if (lastSegment == null || segment.startTimeUs > lastSegment.startTimeUs + 20000000L || !SegmentDownloader.canMergeSegments(lastSegment.dataSpec, segment.dataSpec)) {
                lastIndexByCacheKey.put(cacheKey, nextOutIndex);
                segments.set(nextOutIndex, segment);
                ++nextOutIndex;
                continue;
            }
            long mergedLength = segment.dataSpec.length == -1L ? -1L : lastSegment.dataSpec.length + segment.dataSpec.length;
            DataSpec mergedDataSpec = lastSegment.dataSpec.subrange(0L, mergedLength);
            segments.set(Assertions.checkNotNull(lastIndex), new Segment(lastSegment.startTimeUs, mergedDataSpec));
        }
        Util.removeRange(segments, nextOutIndex, segments.size());
    }

    private static boolean canMergeSegments(DataSpec dataSpec1, DataSpec dataSpec2) {
        return dataSpec1.uri.equals((Object)dataSpec2.uri) && dataSpec1.length != -1L && dataSpec1.position + dataSpec1.length == dataSpec2.position && Util.areEqual(dataSpec1.key, dataSpec2.key) && dataSpec1.flags == dataSpec2.flags && dataSpec1.httpMethod == dataSpec2.httpMethod && dataSpec1.httpRequestHeaders.equals(dataSpec2.httpRequestHeaders);
    }

    protected static class Segment
    implements Comparable<Segment> {
        public final long startTimeUs;
        public final DataSpec dataSpec;

        public Segment(long startTimeUs, DataSpec dataSpec) {
            this.startTimeUs = startTimeUs;
            this.dataSpec = dataSpec;
        }

        @Override
        public int compareTo(Segment other) {
            return Util.compareLong(this.startTimeUs, other.startTimeUs);
        }
    }

    private static final class ProgressNotifier
    implements CacheWriter.ProgressListener {
        private final Downloader.ProgressListener progressListener;
        private final long contentLength;
        private final int totalSegments;
        private long bytesDownloaded;
        private int segmentsDownloaded;

        public ProgressNotifier(Downloader.ProgressListener progressListener, long contentLength, int totalSegments, long bytesDownloaded, int segmentsDownloaded) {
            this.progressListener = progressListener;
            this.contentLength = contentLength;
            this.totalSegments = totalSegments;
            this.bytesDownloaded = bytesDownloaded;
            this.segmentsDownloaded = segmentsDownloaded;
        }

        @Override
        public void onProgress(long requestLength, long bytesCached, long newBytesCached) {
            this.bytesDownloaded += newBytesCached;
            this.progressListener.onProgress(this.contentLength, this.bytesDownloaded, this.getPercentDownloaded());
        }

        public void onSegmentDownloaded() {
            ++this.segmentsDownloaded;
            this.progressListener.onProgress(this.contentLength, this.bytesDownloaded, this.getPercentDownloaded());
        }

        private float getPercentDownloaded() {
            if (this.contentLength != -1L && this.contentLength != 0L) {
                return (float)this.bytesDownloaded * 100.0f / (float)this.contentLength;
            }
            if (this.totalSegments != 0) {
                return (float)this.segmentsDownloaded * 100.0f / (float)this.totalSegments;
            }
            return -1.0f;
        }
    }

    private static final class SegmentDownloadRunnable
    extends RunnableFutureTask<Void, IOException> {
        public final Segment segment;
        public final CacheDataSource dataSource;
        @Nullable
        private final ProgressNotifier progressNotifier;
        public final byte[] temporaryBuffer;
        private final CacheWriter cacheWriter;

        public SegmentDownloadRunnable(Segment segment, CacheDataSource dataSource, @Nullable ProgressNotifier progressNotifier, byte[] temporaryBuffer) {
            this.segment = segment;
            this.dataSource = dataSource;
            this.progressNotifier = progressNotifier;
            this.temporaryBuffer = temporaryBuffer;
            this.cacheWriter = new CacheWriter(dataSource, segment.dataSpec, false, temporaryBuffer, progressNotifier);
        }

        @Override
        protected Void doWork() throws IOException {
            this.cacheWriter.cache();
            if (this.progressNotifier != null) {
                this.progressNotifier.onSegmentDownloaded();
            }
            return null;
        }

        @Override
        protected void cancelWork() {
            this.cacheWriter.cancel();
        }
    }
}

