/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.akamai.amp.exoplayer2.offline.ActionFile;
import com.akamai.amp.exoplayer2.offline.DefaultDownloadIndex;
import com.akamai.amp.exoplayer2.offline.Download;
import com.akamai.amp.exoplayer2.offline.DownloadManager;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import java.io.File;
import java.io.IOException;

public final class ActionFileUpgradeUtil {
    private ActionFileUpgradeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public static void upgradeAndDelete(File actionFilePath, @Nullable DownloadIdProvider downloadIdProvider, DefaultDownloadIndex downloadIndex, boolean deleteOnFailure, boolean addNewDownloadsAsCompleted) throws IOException {
        ActionFile actionFile = new ActionFile(actionFilePath);
        if (actionFile.exists()) {
            boolean success = false;
            try {
                long nowMs = System.currentTimeMillis();
                for (DownloadRequest request : actionFile.load()) {
                    if (downloadIdProvider != null) {
                        request = request.copyWithId(downloadIdProvider.getId(request));
                    }
                    ActionFileUpgradeUtil.mergeRequest(request, downloadIndex, addNewDownloadsAsCompleted, nowMs);
                }
                success = true;
            }
            finally {
                if (success || deleteOnFailure) {
                    actionFile.delete();
                }
            }
        }
    }

    static void mergeRequest(DownloadRequest request, DefaultDownloadIndex downloadIndex, boolean addNewDownloadAsCompleted, long nowMs) throws IOException {
        Download download = downloadIndex.getDownload(request.id);
        download = download != null ? DownloadManager.mergeRequest(download, request, download.stopReason, nowMs) : new Download(request, addNewDownloadAsCompleted ? 3 : 0, nowMs, nowMs, -1L, 0, 0);
        downloadIndex.putDownload(download);
    }

    public static interface DownloadIdProvider {
        public String getId(DownloadRequest var1);
    }
}

