/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.flv;

import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.extractor.flv.TagPayloadReader;
import com.akamai.amp.exoplayer2.util.NalUnitUtil;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.video.AvcConfig;

final class VideoTagPayloadReader
extends TagPayloadReader {
    private static final int VIDEO_CODEC_AVC = 7;
    private static final int VIDEO_FRAME_KEYFRAME = 1;
    private static final int VIDEO_FRAME_VIDEO_INFO = 5;
    private static final int AVC_PACKET_TYPE_SEQUENCE_HEADER = 0;
    private static final int AVC_PACKET_TYPE_AVC_NALU = 1;
    private final ParsableByteArray nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
    private final ParsableByteArray nalLength = new ParsableByteArray(4);
    private int nalUnitLengthFieldLength;
    private boolean hasOutputFormat;
    private boolean hasOutputKeyframe;
    private int frameType;

    public VideoTagPayloadReader(TrackOutput output) {
        super(output);
    }

    @Override
    public void seek() {
        this.hasOutputKeyframe = false;
    }

    @Override
    protected boolean parseHeader(ParsableByteArray data) throws TagPayloadReader.UnsupportedFormatException {
        int header = data.readUnsignedByte();
        int frameType = header >> 4 & 0xF;
        int videoCodec = header & 0xF;
        if (videoCodec != 7) {
            throw new TagPayloadReader.UnsupportedFormatException("Video format not supported: " + videoCodec);
        }
        this.frameType = frameType;
        return frameType != 5;
    }

    @Override
    protected boolean parsePayload(ParsableByteArray data, long timeUs) throws ParserException {
        int packetType = data.readUnsignedByte();
        int compositionTimeMs = data.readInt24();
        timeUs += (long)compositionTimeMs * 1000L;
        if (packetType == 0 && !this.hasOutputFormat) {
            ParsableByteArray videoSequence = new ParsableByteArray(new byte[data.bytesLeft()]);
            data.readBytes(videoSequence.getData(), 0, data.bytesLeft());
            AvcConfig avcConfig = AvcConfig.parse(videoSequence);
            this.nalUnitLengthFieldLength = avcConfig.nalUnitLengthFieldLength;
            Format format = new Format.Builder().setSampleMimeType("video/avc").setWidth(avcConfig.width).setHeight(avcConfig.height).setPixelWidthHeightRatio(avcConfig.pixelWidthAspectRatio).setInitializationData(avcConfig.initializationData).build();
            this.output.format(format);
            this.hasOutputFormat = true;
            return false;
        }
        if (packetType == 1 && this.hasOutputFormat) {
            boolean isKeyframe;
            boolean bl = isKeyframe = this.frameType == 1;
            if (!this.hasOutputKeyframe && !isKeyframe) {
                return false;
            }
            byte[] nalLengthData = this.nalLength.getData();
            nalLengthData[0] = 0;
            nalLengthData[1] = 0;
            nalLengthData[2] = 0;
            int nalUnitLengthFieldLengthDiff = 4 - this.nalUnitLengthFieldLength;
            int bytesWritten = 0;
            while (data.bytesLeft() > 0) {
                data.readBytes(this.nalLength.getData(), nalUnitLengthFieldLengthDiff, this.nalUnitLengthFieldLength);
                this.nalLength.setPosition(0);
                int bytesToWrite = this.nalLength.readUnsignedIntToInt();
                this.nalStartCode.setPosition(0);
                this.output.sampleData(this.nalStartCode, 4);
                bytesWritten += 4;
                this.output.sampleData(data, bytesToWrite);
                bytesWritten += bytesToWrite;
            }
            this.output.sampleMetadata(timeUs, isKeyframe ? 1 : 0, bytesWritten, 0, null);
            this.hasOutputKeyframe = true;
            return true;
        }
        return false;
    }
}

