/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.net.Uri;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.source.ads.AdPlaybackState;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;

public abstract class Timeline {
    public static final Timeline EMPTY = new Timeline(){

        @Override
        public int getWindowCount() {
            return 0;
        }

        @Override
        public Window getWindow(int windowIndex, Window window, long defaultPositionProjectionUs) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getPeriodCount() {
            return 0;
        }

        @Override
        public Period getPeriod(int periodIndex, Period period, boolean setIds) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            return -1;
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            throw new IndexOutOfBoundsException();
        }
    };

    public final boolean isEmpty() {
        return this.getWindowCount() == 0;
    }

    public abstract int getWindowCount();

    public int getNextWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
        switch (repeatMode) {
            case 0: {
                return windowIndex == this.getLastWindowIndex(shuffleModeEnabled) ? -1 : windowIndex + 1;
            }
            case 1: {
                return windowIndex;
            }
            case 2: {
                return windowIndex == this.getLastWindowIndex(shuffleModeEnabled) ? this.getFirstWindowIndex(shuffleModeEnabled) : windowIndex + 1;
            }
        }
        throw new IllegalStateException();
    }

    public int getPreviousWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
        switch (repeatMode) {
            case 0: {
                return windowIndex == this.getFirstWindowIndex(shuffleModeEnabled) ? -1 : windowIndex - 1;
            }
            case 1: {
                return windowIndex;
            }
            case 2: {
                return windowIndex == this.getFirstWindowIndex(shuffleModeEnabled) ? this.getLastWindowIndex(shuffleModeEnabled) : windowIndex - 1;
            }
        }
        throw new IllegalStateException();
    }

    public int getLastWindowIndex(boolean shuffleModeEnabled) {
        return this.isEmpty() ? -1 : this.getWindowCount() - 1;
    }

    public int getFirstWindowIndex(boolean shuffleModeEnabled) {
        return this.isEmpty() ? -1 : 0;
    }

    public final Window getWindow(int windowIndex, Window window) {
        return this.getWindow(windowIndex, window, 0L);
    }

    @Deprecated
    public final Window getWindow(int windowIndex, Window window, boolean setTag) {
        return this.getWindow(windowIndex, window, 0L);
    }

    public abstract Window getWindow(int var1, Window var2, long var3);

    public abstract int getPeriodCount();

    public final int getNextPeriodIndex(int periodIndex, Period period, Window window, int repeatMode, boolean shuffleModeEnabled) {
        int windowIndex = this.getPeriod((int)periodIndex, (Period)period).windowIndex;
        if (this.getWindow((int)windowIndex, (Window)window).lastPeriodIndex == periodIndex) {
            int nextWindowIndex = this.getNextWindowIndex(windowIndex, repeatMode, shuffleModeEnabled);
            if (nextWindowIndex == -1) {
                return -1;
            }
            return this.getWindow((int)nextWindowIndex, (Window)window).firstPeriodIndex;
        }
        return periodIndex + 1;
    }

    public final boolean isLastPeriod(int periodIndex, Period period, Window window, int repeatMode, boolean shuffleModeEnabled) {
        return this.getNextPeriodIndex(periodIndex, period, window, repeatMode, shuffleModeEnabled) == -1;
    }

    public final Pair<Object, Long> getPeriodPosition(Window window, Period period, int windowIndex, long windowPositionUs) {
        return Assertions.checkNotNull(this.getPeriodPosition(window, period, windowIndex, windowPositionUs, 0L));
    }

    @Nullable
    public final Pair<Object, Long> getPeriodPosition(Window window, Period period, int windowIndex, long windowPositionUs, long defaultPositionProjectionUs) {
        long periodPositionUs;
        Assertions.checkIndex(windowIndex, 0, this.getWindowCount());
        this.getWindow(windowIndex, window, defaultPositionProjectionUs);
        if (windowPositionUs == -9223372036854775807L && (windowPositionUs = window.getDefaultPositionUs()) == -9223372036854775807L) {
            return null;
        }
        int periodIndex = window.firstPeriodIndex;
        long periodDurationUs = this.getPeriod(periodIndex, period, true).getDurationUs();
        for (periodPositionUs = window.getPositionInFirstPeriodUs() + windowPositionUs; periodDurationUs != -9223372036854775807L && periodPositionUs >= periodDurationUs && periodIndex < window.lastPeriodIndex; periodPositionUs -= periodDurationUs) {
            periodDurationUs = this.getPeriod(++periodIndex, period, true).getDurationUs();
        }
        return Pair.create((Object)Assertions.checkNotNull(period.uid), (Object)periodPositionUs);
    }

    public Period getPeriodByUid(Object periodUid, Period period) {
        return this.getPeriod(this.getIndexOfPeriod(periodUid), period, true);
    }

    public final Period getPeriod(int periodIndex, Period period) {
        return this.getPeriod(periodIndex, period, false);
    }

    public abstract Period getPeriod(int var1, Period var2, boolean var3);

    public abstract int getIndexOfPeriod(Object var1);

    public abstract Object getUidOfPeriod(int var1);

    public boolean equals(@Nullable Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timeline)) {
            return false;
        }
        Timeline other = (Timeline)obj;
        if (other.getWindowCount() != this.getWindowCount() || other.getPeriodCount() != this.getPeriodCount()) {
            return false;
        }
        Window window = new Window();
        Period period = new Period();
        Window otherWindow = new Window();
        Period otherPeriod = new Period();
        for (i = 0; i < this.getWindowCount(); ++i) {
            if (this.getWindow(i, window).equals(other.getWindow(i, otherWindow))) continue;
            return false;
        }
        for (i = 0; i < this.getPeriodCount(); ++i) {
            if (this.getPeriod(i, period, true).equals(other.getPeriod(i, otherPeriod, true))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        Window window = new Window();
        Period period = new Period();
        int result = 7;
        result = 31 * result + this.getWindowCount();
        for (i = 0; i < this.getWindowCount(); ++i) {
            result = 31 * result + this.getWindow(i, window).hashCode();
        }
        result = 31 * result + this.getPeriodCount();
        for (i = 0; i < this.getPeriodCount(); ++i) {
            result = 31 * result + this.getPeriod(i, period, true).hashCode();
        }
        return result;
    }

    public static final class Window {
        public static final Object SINGLE_WINDOW_UID = new Object();
        private static final MediaItem EMPTY_MEDIA_ITEM = new MediaItem.Builder().setMediaId("com.akamai.amp.exoplayer2.Timeline").setUri(Uri.EMPTY).build();
        public Object uid = SINGLE_WINDOW_UID;
        @Deprecated
        @Nullable
        public Object tag;
        public MediaItem mediaItem = EMPTY_MEDIA_ITEM;
        @Nullable
        public Object manifest;
        public long presentationStartTimeMs;
        public long windowStartTimeMs;
        public long elapsedRealtimeEpochOffsetMs;
        public boolean isSeekable;
        public boolean isDynamic;
        public boolean isLive;
        public boolean isPlaceholder;
        public int firstPeriodIndex;
        public int lastPeriodIndex;
        public long defaultPositionUs;
        public long durationUs;
        public long positionInFirstPeriodUs;

        public Window set(Object uid, @Nullable MediaItem mediaItem, @Nullable Object manifest, long presentationStartTimeMs, long windowStartTimeMs, long elapsedRealtimeEpochOffsetMs, boolean isSeekable, boolean isDynamic, boolean isLive, long defaultPositionUs, long durationUs, int firstPeriodIndex, int lastPeriodIndex, long positionInFirstPeriodUs) {
            this.uid = uid;
            this.mediaItem = mediaItem != null ? mediaItem : EMPTY_MEDIA_ITEM;
            this.tag = mediaItem != null && mediaItem.playbackProperties != null ? mediaItem.playbackProperties.tag : null;
            this.manifest = manifest;
            this.presentationStartTimeMs = presentationStartTimeMs;
            this.windowStartTimeMs = windowStartTimeMs;
            this.elapsedRealtimeEpochOffsetMs = elapsedRealtimeEpochOffsetMs;
            this.isSeekable = isSeekable;
            this.isDynamic = isDynamic;
            this.isLive = isLive;
            this.defaultPositionUs = defaultPositionUs;
            this.durationUs = durationUs;
            this.firstPeriodIndex = firstPeriodIndex;
            this.lastPeriodIndex = lastPeriodIndex;
            this.positionInFirstPeriodUs = positionInFirstPeriodUs;
            this.isPlaceholder = false;
            return this;
        }

        public long getDefaultPositionMs() {
            return C.usToMs(this.defaultPositionUs);
        }

        public long getDefaultPositionUs() {
            return this.defaultPositionUs;
        }

        public long getDurationMs() {
            return C.usToMs(this.durationUs);
        }

        public long getDurationUs() {
            return this.durationUs;
        }

        public long getPositionInFirstPeriodMs() {
            return C.usToMs(this.positionInFirstPeriodUs);
        }

        public long getPositionInFirstPeriodUs() {
            return this.positionInFirstPeriodUs;
        }

        public long getCurrentUnixTimeMs() {
            return Util.getNowUnixTimeMs(this.elapsedRealtimeEpochOffsetMs);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Window that = (Window)obj;
            return Util.areEqual(this.uid, that.uid) && Util.areEqual(this.mediaItem, that.mediaItem) && Util.areEqual(this.manifest, that.manifest) && this.presentationStartTimeMs == that.presentationStartTimeMs && this.windowStartTimeMs == that.windowStartTimeMs && this.elapsedRealtimeEpochOffsetMs == that.elapsedRealtimeEpochOffsetMs && this.isSeekable == that.isSeekable && this.isDynamic == that.isDynamic && this.isLive == that.isLive && this.isPlaceholder == that.isPlaceholder && this.defaultPositionUs == that.defaultPositionUs && this.durationUs == that.durationUs && this.firstPeriodIndex == that.firstPeriodIndex && this.lastPeriodIndex == that.lastPeriodIndex && this.positionInFirstPeriodUs == that.positionInFirstPeriodUs;
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + this.uid.hashCode();
            result = 31 * result + this.mediaItem.hashCode();
            result = 31 * result + (this.manifest == null ? 0 : this.manifest.hashCode());
            result = 31 * result + (int)(this.presentationStartTimeMs ^ this.presentationStartTimeMs >>> 32);
            result = 31 * result + (int)(this.windowStartTimeMs ^ this.windowStartTimeMs >>> 32);
            result = 31 * result + (int)(this.elapsedRealtimeEpochOffsetMs ^ this.elapsedRealtimeEpochOffsetMs >>> 32);
            result = 31 * result + (this.isSeekable ? 1 : 0);
            result = 31 * result + (this.isDynamic ? 1 : 0);
            result = 31 * result + (this.isLive ? 1 : 0);
            result = 31 * result + (this.isPlaceholder ? 1 : 0);
            result = 31 * result + (int)(this.defaultPositionUs ^ this.defaultPositionUs >>> 32);
            result = 31 * result + (int)(this.durationUs ^ this.durationUs >>> 32);
            result = 31 * result + this.firstPeriodIndex;
            result = 31 * result + this.lastPeriodIndex;
            result = 31 * result + (int)(this.positionInFirstPeriodUs ^ this.positionInFirstPeriodUs >>> 32);
            return result;
        }
    }

    public static final class Period {
        @Nullable
        public Object id;
        @Nullable
        public Object uid;
        public int windowIndex;
        public long durationUs;
        private long positionInWindowUs;
        private AdPlaybackState adPlaybackState = AdPlaybackState.NONE;

        public Period set(@Nullable Object id, @Nullable Object uid, int windowIndex, long durationUs, long positionInWindowUs) {
            return this.set(id, uid, windowIndex, durationUs, positionInWindowUs, AdPlaybackState.NONE);
        }

        public Period set(@Nullable Object id, @Nullable Object uid, int windowIndex, long durationUs, long positionInWindowUs, AdPlaybackState adPlaybackState) {
            this.id = id;
            this.uid = uid;
            this.windowIndex = windowIndex;
            this.durationUs = durationUs;
            this.positionInWindowUs = positionInWindowUs;
            this.adPlaybackState = adPlaybackState;
            return this;
        }

        public long getDurationMs() {
            return C.usToMs(this.durationUs);
        }

        public long getDurationUs() {
            return this.durationUs;
        }

        public long getPositionInWindowMs() {
            return C.usToMs(this.positionInWindowUs);
        }

        public long getPositionInWindowUs() {
            return this.positionInWindowUs;
        }

        public int getAdGroupCount() {
            return this.adPlaybackState.adGroupCount;
        }

        public long getAdGroupTimeUs(int adGroupIndex) {
            return this.adPlaybackState.adGroupTimesUs[adGroupIndex];
        }

        public int getFirstAdIndexToPlay(int adGroupIndex) {
            return this.adPlaybackState.adGroups[adGroupIndex].getFirstAdIndexToPlay();
        }

        public int getNextAdIndexToPlay(int adGroupIndex, int lastPlayedAdIndex) {
            return this.adPlaybackState.adGroups[adGroupIndex].getNextAdIndexToPlay(lastPlayedAdIndex);
        }

        public boolean hasPlayedAdGroup(int adGroupIndex) {
            return !this.adPlaybackState.adGroups[adGroupIndex].hasUnplayedAds();
        }

        public int getAdGroupIndexForPositionUs(long positionUs) {
            return this.adPlaybackState.getAdGroupIndexForPositionUs(positionUs, this.durationUs);
        }

        public int getAdGroupIndexAfterPositionUs(long positionUs) {
            return this.adPlaybackState.getAdGroupIndexAfterPositionUs(positionUs, this.durationUs);
        }

        public int getAdCountInAdGroup(int adGroupIndex) {
            return this.adPlaybackState.adGroups[adGroupIndex].count;
        }

        public long getAdDurationUs(int adGroupIndex, int adIndexInAdGroup) {
            AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
            return adGroup.count != -1 ? adGroup.durationsUs[adIndexInAdGroup] : -9223372036854775807L;
        }

        public long getAdResumePositionUs() {
            return this.adPlaybackState.adResumePositionUs;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Period that = (Period)obj;
            return Util.areEqual(this.id, that.id) && Util.areEqual(this.uid, that.uid) && this.windowIndex == that.windowIndex && this.durationUs == that.durationUs && this.positionInWindowUs == that.positionInWindowUs && Util.areEqual(this.adPlaybackState, that.adPlaybackState);
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            result = 31 * result + this.windowIndex;
            result = 31 * result + (int)(this.durationUs ^ this.durationUs >>> 32);
            result = 31 * result + (int)(this.positionInWindowUs ^ this.positionInWindowUs >>> 32);
            result = 31 * result + this.adPlaybackState.hashCode();
            return result;
        }
    }
}

